package com.lanren.huhu.partner.manager;

import com.alibaba.fastjson.JSON;
import com.lanren.huhu.partner.domain.UserAgent;
import com.lanren.huhu.partner.model.AgentResponse;
import com.lanren.huhu.partner.model.AgentRewardMessage;
import com.lanren.huhu.partner.model.ParentAgent;
import com.lanren.huhu.partner.result.Result;
import com.lanren.huhu.partner.schedule.AgentSettleTask;
import com.lanren.huhu.partner.service.UserAgentService;
import com.lanren.huhu.partner.service.UserService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.ListOperations;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;

import static com.lanren.huhu.partner.constants.Constants.*;

/**
 * @author chen
 */
@Component
public class AgentManager {
    private static Logger logger = LoggerFactory.getLogger(AgentManager.class);

    @Autowired
    UserAgentService userAgentService;
    @Autowired
    StringRedisTemplate redisTemplate;
    @Autowired
    AgentSettleTask agentSettleTask;
    @Autowired
    UserService userService;

    /***
     * * 获取代理商等级 1 总代, 2 大区, 3 省, 4 市
     * @param agentId
     * @return
     */
    public Result<AgentResponse> getAgentLevel(Integer agentId) {
        if (logger.isDebugEnabled()) {
            logger.info("UserAgentManager getLevel agentId:{},time:{}", agentId, LocalDateTime.now());
        }
        Result<AgentResponse> result = new Result<>();
        UserAgent userAgent = userAgentService.getOneByAgentId(agentId);
        if (null != userAgent) {
            result.setData(new AgentResponse(userAgent.getUserId(), userAgent.getAgentLevel()));
        } else {
            result.setCode(601);
        }
        return result;
    }

    /**
     * @description: 测试使用, 推送一条代理商奖励的待处理消息到redis队列
     * @author chen
     * @date 2019-07-04 14:48
     */
    public Result<String> pushReward() {
        ListOperations<String, String> ops = redisTemplate.opsForList();
        AgentRewardMessage agentRewardMessage = new AgentRewardMessage();
        agentRewardMessage.setRewardType(710);
        agentRewardMessage.setRechargeTime("2019-06-29 01:23:45");
        agentRewardMessage.setSourceUserId(2328);
        agentRewardMessage.setReferenceId("9999");
        agentRewardMessage.setAgentId(33);
//        agentRewardMessage.setAgentReward(new BigDecimal(0));
        agentRewardMessage.setSourceUserPayment(new BigDecimal(5));
        agentRewardMessage.setSettleState(-100);
        agentRewardMessage.setOrderType("taobao");
        agentRewardMessage.setOrderSn("507596802910534728");
        agentRewardMessage.setSubOrderSn("507596802910534728");
        agentRewardMessage.setOrderCommission(new BigDecimal("35.400000"));
        agentRewardMessage.setSourceOrder("8888");
        logger.info("写入队列");
        ops.leftPush(AGENT_REWARD_QUEUE_KEY, JSON.toJSONString(agentRewardMessage));
        return new Result<>();
    }
    /**
     * @description: 获取一个代理商的层级上级
     * @author chen
     * @date 2019-07-04 14:48
     */
    public Result<ArrayList<ParentAgent>> getHierarchyParentList(Integer agentId) {
        UserAgent userAgent = userAgentService.getOneByAgentId(agentId);
        ArrayList<ParentAgent> parentAgents = (ArrayList<ParentAgent>) userService.getAgentListByUserId(userAgent.getUserId(), PARENT_COLUMN_NAME_CENGJI);
        Result<ArrayList<ParentAgent>> result = new Result<ArrayList<ParentAgent>>();
        result.setData(parentAgents);
        return result;
    }
    /**
     * @description: 获取一个代理商的平推上级
     * @author chen
     * @date 2019-07-04 14:48
     */
    public Result<ArrayList<ParentAgent>> getPingtuiParentList(Integer agentId) {
        UserAgent userAgent = userAgentService.getOneByAgentId(agentId);
        ArrayList<ParentAgent> parentAgents = (ArrayList<ParentAgent>) userService.getAgentListByUserId(userAgent.getUserId(), PARENT_COLUMN_NAME_PINGTUI);
        Result<ArrayList<ParentAgent>> result = new Result<ArrayList<ParentAgent>>();
        result.setData(parentAgents);
        return result;
    }

    public Result<String> doFinanceSettle(int agentId) {
        Result<String> result = new Result<String>();
        if (agentSettleTask.doOneAgentSettle(agentId)) {
            result.setCode(0);
        } else {
            result.setCode(500);
        }
        return result;
    }
}
