package com.lanren.huhu.partner.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.math.BigDecimal;
import lombok.Data;

@Data
@TableName(value = "partner_activation_relation_record")
public class PartnerActivationRelationRecord implements Serializable {
    /**
     * 主键
     */
     @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    /**
     * 激活奖励规则表主键
     */
    @TableField(value = "rid")
    private Integer rid;

    /**
     * 激活得订单号
     */
    @TableField(value = "active_order_id")
    private String activeOrderId;

    /**
     * 激活得订单号类型
     */
    @TableField(value = "active_order_type")
    private String activeOrderType;

    /**
     * 直接邀请人ID
     */
    @TableField(value = "invite_user_id")
    private Integer inviteUserId;

    /**
     * 直接奖励类型 默认0、10现金 20 红包
     */
    @TableField(value = "invite_reward_type")
    private Integer inviteRewardType;

    /**
     * 直接奖励金额
     */
    @TableField(value = "invite_amout")
    private BigDecimal inviteAmout;

    /**
     * 间接邀请人ID
     */
    @TableField(value = "indirect_invite_uid")
    private Integer indirectInviteUid;

    /**
     * 间接奖励类型 默认0、10现金 20 红包
     */
    @TableField(value = "indirect_reward_type")
    private Integer indirectRewardType;

    /**
     * 间接奖励金额
     */
    @TableField(value = "indirect_amout")
    private BigDecimal indirectAmout;

    /**
     * 10待奖励  20已结算（高伟 由10改为20） 120 已结算（关晨 由10->120） 30 已返回
     */
    @TableField(value = "reward_state")
    private Integer rewardState;

    /**
     * 激活时间
     */
    @TableField(value = "active_time")
    private Integer activeTime;

    /**
     * 结算时间
     */
    @TableField(value = "settle_time")
    private Integer settleTime;

    /**
     * 创建时间
     */
    @TableField(value = "created_at")
    private Integer createdAt;

    /**
     * 修改时间
     */
    @TableField(value = "updated_at")
    private Integer updatedAt;

    private static final long serialVersionUID = 1L;

    public static final String COL_RID = "rid";

    public static final String COL_ACTIVE_ORDER_ID = "active_order_id";

    public static final String COL_ACTIVE_ORDER_TYPE = "active_order_type";

    public static final String COL_INVITE_USER_ID = "invite_user_id";

    public static final String COL_INVITE_REWARD_TYPE = "invite_reward_type";

    public static final String COL_INVITE_AMOUT = "invite_amout";

    public static final String COL_INDIRECT_INVITE_UID = "indirect_invite_uid";

    public static final String COL_INDIRECT_REWARD_TYPE = "indirect_reward_type";

    public static final String COL_INDIRECT_AMOUT = "indirect_amout";

    public static final String COL_REWARD_STATE = "reward_state";

    public static final String COL_ACTIVE_TIME = "active_time";

    public static final String COL_SETTLE_TIME = "settle_time";

    public static final String COL_CREATED_AT = "created_at";

    public static final String COL_UPDATED_AT = "updated_at";
}