package com.lanren.huhu.partner.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author houseme
 */
@Data
@TableName(value = "partner_account")
public class PartnerAccount implements Serializable {
     @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    /**
     * 关联用户id
     */
    @TableField(value = "user_id")
    private Integer userId;

    /**
     * 合伙人等级 普通10 高级20, 如果是超级合伙人这里是成为超级之前的级别
     */
    @TableField(value = "partner_level")
    private Integer partnerLevel;

    /**
     * 如果是高级记成为高级的时间
     */
    @TableField(value = "become_high_time")
    private LocalDateTime becomeHighTime;

    /**
     * 是否是超级合伙人 1是 0不是 默认不是
     */
    @TableField(value = "is_super_partner")
    private Integer isSuperPartner;

    /**
     * 如果是超级合伙人记成为超级的时间
     */
    @TableField(value = "become_super_time")
    private LocalDateTime becomeSuperTime;

    /**
     * 账户税前收入总额
     */
    @TableField(value = "all_income")
    private BigDecimal allIncome;

    /**
     * 当前账期未记账总额
     */
    @TableField(value = "curr_untaxed_income")
    private BigDecimal currUntaxedIncome;

    /**
     * 扣款金额
     */
    @TableField(value = "revoke_balance")
    private BigDecimal revokeBalance;

    /**
     * 用户首月可立即提现金额:  小于等于800 属未记账
     */
    @TableField(value = "first_month_free")
    private BigDecimal firstMonthFree;

    /**
     * 税后总收入=微信可提+已提+银行卡可提+已提
     */
    @TableField(value = "income_after_tax")
    private BigDecimal incomeAfterTax;

    /**
     * 微信可提现总额
     */
    @TableField(value = "wx_free_balance")
    private BigDecimal wxFreeBalance;

    /**
     * 微信已提现总额
     */
    @TableField(value = "wx_withdrawn_balance")
    private BigDecimal wxWithdrawnBalance;

    /**
     * 银行卡可提现总额
     */
    @TableField(value = "bank_free_balance")
    private BigDecimal bankFreeBalance;

    /**
     * 银行卡已提现总额
     */
    @TableField(value = "bank_withdrawn_balance")
    private BigDecimal bankWithdrawnBalance;

    /**
     * 提现冻结
     */
    @TableField(value = "frozen_withdraw_balance")
    private BigDecimal frozenWithdrawBalance;

    /**
     * 微信提现冻结
     */
    @TableField(value = "frozen_wx_withdraw_balance")
    private BigDecimal frozenWxWithdrawBalance;

    /**
     * 银行卡提现冻结
     */
    @TableField(value = "frozen_bank_withdraw_balance")
    private BigDecimal frozenBankWithdrawBalance;

    /**
     * 获得第一笔收入的时间戳
     */
    @TableField(value = "first_income_time")
    private Long firstIncomeTime;

    @TableField(value = "created_at")
    private Long createdAt;

    @TableField(value = "updated_at")
    private Long updatedAt;

    @TableField(value = "deleted_at")
    private Long deletedAt;

    /**
     * 创建时间戳
     */
    @TableField(value = "create_time")
    private LocalDateTime createTime;

    /**
     * 会员截止日期
     */
    @TableField(value = "vip_deadline")
    private Integer vipDeadline;

    private static final long serialVersionUID = 1L;

    public static final String COL_USER_ID = "user_id";

    public static final String COL_PARTNER_LEVEL = "partner_level";

    public static final String COL_BECOME_HIGH_TIME = "become_high_time";

    public static final String COL_IS_SUPER_PARTNER = "is_super_partner";

    public static final String COL_BECOME_SUPER_TIME = "become_super_time";

    public static final String COL_ALL_INCOME = "all_income";

    public static final String COL_CURR_UNTAXED_INCOME = "curr_untaxed_income";

    public static final String COL_REVOKE_BALANCE = "revoke_balance";

    public static final String COL_FIRST_MONTH_FREE = "first_month_free";

    public static final String COL_INCOME_AFTER_TAX = "income_after_tax";

    public static final String COL_WX_FREE_BALANCE = "wx_free_balance";

    public static final String COL_WX_WITHDRAWN_BALANCE = "wx_withdrawn_balance";

    public static final String COL_BANK_FREE_BALANCE = "bank_free_balance";

    public static final String COL_BANK_WITHDRAWN_BALANCE = "bank_withdrawn_balance";

    public static final String COL_FROZEN_WITHDRAW_BALANCE = "frozen_withdraw_balance";

    public static final String COL_FROZEN_WX_WITHDRAW_BALANCE = "frozen_wx_withdraw_balance";

    public static final String COL_FROZEN_BANK_WITHDRAW_BALANCE = "frozen_bank_withdraw_balance";

    public static final String COL_FIRST_INCOME_TIME = "first_income_time";

    public static final String COL_CREATED_AT = "created_at";

    public static final String COL_UPDATED_AT = "updated_at";

    public static final String COL_DELETED_AT = "deleted_at";

    public static final String COL_CREATE_TIME = "create_time";

    public static final String COL_VIP_DEADLINE = "vip_deadline";
}