package com.lanren.huhu.partner.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.math.BigDecimal;
import lombok.Data;

@Data
@TableName(value = "agent_income_summary")
public class AgentIncomeSummary implements Serializable {
    /**
     * ID序号
     */
     @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 用户id
     */
    @TableField(value = "user_id")
    private Integer userId;

    /**
     * 代理商id
     */
    @TableField(value = "agent_id")
    private Integer agentId;

    /**
     * 年份
     */
    @TableField(value = "yeartime")
    private Integer yeartime;

    /**
     * 月份
     */
    @TableField(value = "monthtime")
    private Integer monthtime;

    /**
     * 结算金额
     */
    @TableField(value = "income")
    private BigDecimal income;

    /**
     * 结算内容
     */
    @TableField(value = "content")
    private String content;

    /**
     * 结算状态 10未结算20已结算
     */
    @TableField(value = "state")
    private Integer state;

    /**
     * 结算时间
     */
    @TableField(value = "settle_time")
    private Integer settleTime;

    /**
     * 创建时间
     */
    @TableField(value = "created_at")
    private Integer createdAt;

    /**
     * 更新时间
     */
    @TableField(value = "updated_at")
    private Integer updatedAt;

    private static final long serialVersionUID = 1L;

    public static final String COL_USER_ID = "user_id";

    public static final String COL_AGENT_ID = "agent_id";

    public static final String COL_YEARTIME = "yeartime";

    public static final String COL_MONTHTIME = "monthtime";

    public static final String COL_INCOME = "income";

    public static final String COL_CONTENT = "content";

    public static final String COL_STATE = "state";

    public static final String COL_SETTLE_TIME = "settle_time";

    public static final String COL_CREATED_AT = "created_at";

    public static final String COL_UPDATED_AT = "updated_at";
}