package com.lanren.huhu.partner.dao;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.lanren.huhu.partner.domain.UserAgent;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.SelectProvider;

import java.util.List;

@Mapper
public interface UserAgentMapper extends BaseMapper<UserAgent> {
    int updateBatch(List<UserAgent> list);

    int batchInsert(@Param("list") List<UserAgent> list);

    int insertOrUpdate(UserAgent record);

    int insertOrUpdateSelective(UserAgent record);

    /**
     * 按agentId查找上级 UserAgent
     * 注意!!!!!!!!!!!! 查找上级用的是字段 presenter_id
     * @param agentId
     * @return
     */
    @SelectProvider(type = UserAgentSqlProvider.class, method = "getParentAgent")
    UserAgent getParentAgent(@Param("agentId") Integer agentId, @Param("parentColumnName") String parentColumnName);
    /**
     * 按uid查找下级 UserAgent
     */
    @SelectProvider(type = UserAgentSqlProvider.class, method = "getChildListByUserId")
    List<UserAgent> getChildListByUserId(@Param("userId") Integer userId, @Param("parentColumnName") String parentColumnName);

    UserAgent getUserAgentByPhone(String phone);
}