package com.lanren.huhu.partner.config;

import com.lanren.huhu.partner.service.impl.RedissonLockService;
import com.lanren.huhu.partner.util.LockUtil;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.config.Config;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.io.IOException;

/**
 * @author chen
 * @title: RedissonConfig
 * @projectName partner
 * @description: 注入锁工具类
 * @package com.lanren.huhu.partner.config
 * @date 2019-07-01 19:41
 */
@Configuration
public class RedissonConfig {
    @Value("${spring.redis.host}")
    private String host;
    @Value("${spring.redis.port}")
    private String port;
    @Value("${spring.redis.password}")
    private String password;

    /**
     * RedissonClient,单机模式
     * @return
     * @throws IOException
     */
    @Bean(destroyMethod = "shutdown")
    public RedissonClient redisson() throws IOException {
        Config config = new Config();
        config.useSingleServer().setAddress("redis://" + host + ":" + port).setPassword(password);
        return Redisson.create(config);
    }

    @Bean
    public RedissonLockService redissonLocker(RedissonClient redissonClient){
        RedissonLockService locker = new RedissonLockService(redissonClient);
        //设置LockUtil的锁处理对象
        try{
            LockUtil.setLockService(locker);
        } catch (Exception e) {
            System.out.println("redissonLocker failed");
            System.out.println(e.getMessage());
        }
        return locker;
    }
}
