package com.lanren.huhu.partner.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.lanren.huhu.partner.dao.PartnerAccountMapper;
import com.lanren.huhu.partner.dao.UserAgentMapper;
import com.lanren.huhu.partner.domain.PartnerAccount;
import com.lanren.huhu.partner.domain.UserAgent;
import com.lanren.huhu.partner.model.ParentAgent;
import com.lanren.huhu.partner.model.ParentPartner;
import com.lanren.huhu.partner.model.User;
import com.lanren.huhu.partner.service.UserService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * @author houseme
 * @date 2019-06-28 18:36
 * @Project partner
 * @Package com.lanren.huhu.partner.service.impl
 * @File: UserServiceImpl
 */
@Service
@CacheConfig(cacheNames = "user:relation:cache")
public class UserServiceImpl implements UserService {
    private static Logger logger = LoggerFactory.getLogger(UserServiceImpl.class);

    @Autowired
    private UserAgentMapper userAgentMapper;

    @Autowired
    private PartnerAccountMapper partnerAccountMapper;

    /**
     * 用户上级 合伙人 和 代理 关系
     * @param userId
     * @return
     */
    @Override
    @Cacheable
    public User getRelationByUserId(Integer userId) {
        logger.info("new a user object ");
        if (logger.isDebugEnabled()) {
            logger.info("new a user object ");
        }
        User user = new User();
        user.setUserId(userId);
        user.setPartnerList((ArrayList<ParentPartner>) getPartnerListByUserId(userId));
        user.setAgentList((ArrayList<ParentAgent>) getAgentListByUserId(userId));
        return user;
    }
    @Override
    @CacheEvict(key = "#userId")
    public boolean deleteRalationByUserId(Integer userId) {
        if (logger.isInfoEnabled()) {
            logger.info("delete user relation cache, userId: {}", userId);
        }
        return true;
    }

    /**
     * 合伙人数据
     * @param userId
     * @return
     */
    @Override
    public PartnerAccount getPartnerAccountByUserId(Integer userId) {
        QueryWrapper<PartnerAccount> queryWrapper = new QueryWrapper();
        queryWrapper.eq("user_id", userId);
        return partnerAccountMapper.selectOne(queryWrapper);
    }
    @Override
    public List<PartnerAccount> getPartnerAccountChildrenByUserId(Integer userId) {
        return partnerAccountMapper.getChildrenByUserId(userId);
    }
    @Override
    public ParentPartner getParentPartner(Integer userId) {
        PartnerAccount partnerAccount = partnerAccountMapper.getParentByUserId(userId);
        ParentPartner parentPartner = null;
        if (null != partnerAccount) {
            int partnerLevel = partnerAccount.getIsSuperPartner() == 1 ? 30 : partnerAccount.getPartnerLevel();
            parentPartner = new ParentPartner(partnerAccount.getUserId(),partnerLevel);
        }
        return parentPartner;
    }
    @Override
    public List<ParentPartner> getPartnerListByUserId(Integer userId) {
        if (logger.isInfoEnabled()) {
            logger.info("begin setPartnerList for user: {} ......", userId);
        }
        ArrayList<ParentPartner> partnerList = new ArrayList<ParentPartner>();
        /**
         * 无限找
         */
        int loopUserId = userId;
        int loopTimes = 0;
        while (true) {
            if (logger.isDebugEnabled()) {
                logger.info("now loop uid is {}", loopUserId);
            }
            ParentPartner parentPartner = getParentPartner(loopUserId);
            if (null == parentPartner) {
                break;
            } else {
                if (logger.isDebugEnabled()) {
                    logger.info("parent is {} ", parentPartner.getUserId());
                }
                partnerList.add(parentPartner);
                loopUserId = parentPartner.getUserId();
                loopTimes++;
                if (loopTimes > 500) {
                    partnerList.clear();
                    logger.error("用户:{} 邀请关系异常, 已超500层", userId);
                    break;
                }
            }
        }
        if (logger.isInfoEnabled()) {
            logger.info("setPartnerList for user: {} end", userId);
        }
        return partnerList;
    }

    /**
     * 代理商数据
     * @param userId
     * @return
     */
    @Override
    public UserAgent getUserAgentByUserId(Integer userId) {
        QueryWrapper<UserAgent> queryWrapper = new QueryWrapper();
        queryWrapper.eq("user_id", userId).le("agent_level", 4);
        return userAgentMapper.selectOne(queryWrapper);
    }
    @Override
    public ParentAgent getParentAgent(Integer agentId) {
        UserAgent userAgent = userAgentMapper.getParentAgent(agentId);
        ParentAgent parentAgent = null;
        if (null != userAgent) {
            int agentLevel = userAgent.getAgentLevel();
            parentAgent = new ParentAgent(userAgent.getUserId(), userAgent.getAgentId(), agentLevel);
        }
        return parentAgent;
    }
    @Override
    public List<ParentAgent> getAgentListByUserId(Integer userId) {
        if (logger.isInfoEnabled()) {
            logger.info("begin setAgentList for user: {} ......", userId);
        }
        ArrayList<ParentAgent> agentList = new ArrayList<ParentAgent>();
        /**
         * 无限找
         * 先无限找上级合伙人, 直到找到第一个是代理商的合伙人
         */
        int loopUserId = userId;
        int loopTimes = 0;
        while (true) {
            if (logger.isDebugEnabled()) {
                logger.info("now loop uid is {}", loopUserId);
            }
            ParentPartner parentPartner = getParentPartner(loopUserId);
            /**
             * 有上级合伙人
             */
            if (null != parentPartner) {
                UserAgent userAgent = getUserAgentByUserId(parentPartner.getUserId());
                /**
                 * 找到了第一个是代理商的合伙人
                 */
                if (null != userAgent) {
                    /**
                     * 然后开始 无限找 这个人的上级代理商
                     */
                    if (logger.isDebugEnabled()) {
                        logger.info("find first agent({}) for user: {}", userAgent.getAgentId(), userId);
                    }
                    agentList.add(new ParentAgent(userAgent.getUserId(), userAgent.getAgentId(), userAgent.getAgentLevel()));
                    loopTimes++;
                    if (logger.isDebugEnabled()) {
                        logger.info("loop find parent agent start ......");
                    }
                    int loogAgentId = userAgent.getAgentId();
                    while (true) {
                        ParentAgent loopUserAgent = getParentAgent(loogAgentId);
                        if (null == loopUserAgent) {
                            break;
                        } else {
                            if (logger.isDebugEnabled()) {
                                logger.info("parent agent is ", loopUserAgent.getAgentId());
                            }
                            agentList.add(new ParentAgent(loopUserAgent.getUserId(), loopUserAgent.getAgentId(), loopUserAgent.getLevel()));
                            loogAgentId = loopUserAgent.getAgentId();
                            loopTimes++;
                            if (loopTimes > 500) {
                                agentList.clear();
                                logger.error("用户ID:{} 代理商关系异常, 已超500层", userId);
                                break;
                            }
                        }
                    }
                    /**
                     * 找完 "第一个是代理商的合伙人" 的 全部上级代理后 退出while循环
                     */
                    if (logger.isDebugEnabled()) {
                        logger.info("loop find parent agent end");
                    }
                    break;
                } else {
                    /**
                     * 这个人不是代理商 继续往上找
                     */
                    loopUserId = parentPartner.getUserId();
                }
            } else {
                /**
                 * 没有上级合伙人 打印结束信息 跳出循环
                 */
                if (logger.isDebugEnabled()) {
                    logger.info("loop end with userId: {}", loopUserId);
                }
                break;
            }
        }
        if (logger.isInfoEnabled()) {
            logger.info("setAgentList for user: {} end", userId);
        }
        return agentList;
    }
}
