package com.lanren.huhu.partner.service;

import com.lanren.huhu.partner.domain.PartnerAccount;
import com.lanren.huhu.partner.domain.UserAgent;
import com.lanren.huhu.partner.model.ParentAgent;
import com.lanren.huhu.partner.model.ParentPartner;
import com.lanren.huhu.partner.model.User;

import java.util.List;

/**
 * @author houseme
 * @date 2019-06-28 18:35
 * @Project partner
 * @Package com.lanren.huhu.partner.service
 * @File: UserService
 */
public interface UserService {

    /**
     * @description: 根据用户id, 查找一个用户的全部合伙人上级 和 代理商上级
     *       缓存用户邀请关系和代理商关系数据
     *       缓存不能带有构造方法的Bean 所以只能返回User的Bean
     *       包装Result在Cacheable注解的方法之外进行操作
     * @param userId
     * @return User
     * @throws
     * @author chen
     * @date 2019-06-26 20:01
     */
    User getRelationByUserId(Integer userId);
    /**
     * 清理用户缓存
     */
    boolean deleteRalationByUserId(Integer userId);

    /***
     * PartnerAccount
     *
     * 根据用户id查询账户信息
     * @param userId
     * @return PartnerAccount
     */
    PartnerAccount getPartnerAccountByUserId(Integer userId);
    /**
     * @description: TODO
     * @param userId
     * @return List<PartnerAccount>
     * @author chen
     * @date 2019-06-28 11:49
     */
    List<PartnerAccount> getPartnerAccountChildrenByUserId(Integer userId);

    /***
     * UserAgent
     * 根据用户id查询账户信息
     * @param userId
     * @return
     */
    UserAgent getUserAgentByUserId(Integer userId);

    /**
     * 按userId查找上级合伙人的 userId 和 level
     * @param userId
     * @return
     */
    ParentPartner getParentPartner(Integer userId);

    /**
     * @description: 查找一个用户的全部合伙人上级, set到User对象的partnerList中
     * @param userId
     * @author chen
     * @return List<ParentPartner>
     */
    List<ParentPartner> getPartnerListByUserId(Integer userId);

    /**
     * 按agentId 查找上级代理商的 agentId 和 level
     * @param agentId
     * @return
     */
    ParentAgent getParentAgent(Integer agentId);
    /**
     * @description: 查找一个用户的全部代理商上级 set到User对象的agentList中
     * @param userId
     * @return List<ParentAgent>
     */
    List<ParentAgent> getAgentListByUserId(Integer userId);

}