package com.lanren.huhu.partner.manager;

import com.lanren.huhu.partner.domain.PartnerAccount;
import com.lanren.huhu.partner.model.ParentPartner;
import com.lanren.huhu.partner.model.PartnerTree;
import com.lanren.huhu.partner.model.User;
import com.lanren.huhu.partner.result.Result;
import com.lanren.huhu.partner.service.UserService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

import java.util.ArrayList;

/**
 * @author houseme
 */
@Component
public class UserManager {
    private static Logger logger = LoggerFactory.getLogger(UserManager.class);

    @Autowired
    UserService userService;

    public Result<User> getRelationByUserId(int userId) {
        User resutrnUser = userService.getRelationByUserId(userId);
        Result<User> result = new Result<User>();
        result.setData(resutrnUser);
        return result;
    }

    public Result<String> deleteRalationByUserId(int userId) {
        Result<String> result = new Result<String>();
        if (userService.deleteRalationByUserId(userId)) {
            result.setData("删除成功");
        } else {
            result.setCode(500);
        }
        return result;
    }

    /**
     * 根据输入的userId, 完成递归查找
     * @param userId
     */
    @Async
    public Result<String> changeRelation(Integer userId) {
        Result<String> result = new Result<String>();
        try{
            logger.info("start changeRelation for userId: {} ...", userId);
            PartnerAccount partnerAccount = userService.getPartnerAccountByUserId(userId);
            if (partnerAccount == null) {
                result.setCode(413);
            }
            int partnerLevel = partnerAccount.getIsSuperPartner() == 1 ? 30 : partnerAccount.getPartnerLevel();
            PartnerTree root = new PartnerTree();
            root.setUserId(partnerAccount.getUserId());
            root.setLevel(partnerLevel);
            root.setParentList(new ArrayList<ParentPartner>());
            recursiveSet(root);
            logger.info("done changeRelation for userId: {}", userId);
            result.setData("用户刷新成功");
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            result.setCode(500);
        }
        return result;
    }

    /**
     * 递归查找, 完成输入的tree的所有下级查找
     * @param tree
     */
    private void recursiveSet(PartnerTree tree) {
        logger.info("do recursiveSet for userId: {}", tree.getUserId());
        if (logger.isDebugEnabled()) {
            logger.info("do recursiveSet for userId: {}", tree.getUserId());
        }
        /**
         * 先找到直接下级
         */
        setChildren(tree);
        ArrayList<PartnerTree> children = tree.getChildrenList();
        /**
         * 如果没有下级了 那么直接输出结果
         */
        if (children.size() == 0) {
            outputTree(tree);
        } else {
            /**
             * 如果有直接下级, 遍历下级, 对每个下级再执行recursiveSet
             */
            for (PartnerTree child : children) {
                recursiveSet(child);
                /**
                 * 当完成 对每个下级再执行recursiveSet 之后
                 * 判断一下, 每个下级是否有直接下级
                 * 如果有 那么在各自的recursiveSet中 应该没有走到 line:52 的outputTree 方法
                 * 所以要在这里执行一次, 把他们自己输出
                 */
                if (child.getChildrenList().size() > 0) {
                    outputTree(child);
                }
            }
            /**
             * 最后输出自己
             */
            outputTree(tree);
        }
    }

    /**
     * 完成刷新用户缓存数据
     * @param tree
     */
    private void outputTree(PartnerTree tree) {
        StringBuilder sb = new StringBuilder();
        ArrayList<ParentPartner> list = tree.getParentList();
        for (ParentPartner p : list) {
            sb.append(p.getUserId()).append(",");
        }
        if (logger.isDebugEnabled()) {
            logger.info("begin to refresh cache......");
            logger.info("userId: {}, parent is: {}", tree.getUserId(), sb.toString());
        }
        deleteRalationByUserId(tree.getUserId());
        getRelationByUserId(tree.getUserId());
    }

    /**
     * 无递归操作, 只往下查找一级
     * 把下级的数据, 设置到输入的tree中的childrenList
     * @param tree
     */
    private void setChildren(PartnerTree tree) {
        ArrayList<PartnerAccount> partnerAccountArrayList = (ArrayList<PartnerAccount>) userService.getPartnerAccountChildrenByUserId(tree.getUserId());
        for (PartnerAccount partnerAccount : partnerAccountArrayList) {
            Integer childId = partnerAccount.getUserId();
            Integer childLevel = partnerAccount.getIsSuperPartner() == 1 ? 30 : partnerAccount.getPartnerLevel();
            if (!tree.getParentList().contains(childId)) {
                ArrayList<ParentPartner> parentList4Child = tree.cloneParent();
                parentList4Child.add(new ParentPartner(tree.getUserId(), tree.getLevel()));
                PartnerTree oneChild = new PartnerTree();
                oneChild.setUserId(childId);
                oneChild.setLevel(childLevel);
                oneChild.setParentList(parentList4Child);
                tree.getChildrenList().add(oneChild);
            }
        }
    }
}
