package com.lanren.huhu.partner.manager;

import com.lanren.huhu.partner.util.MessageUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

/**
 * 初始化加载参数到内存中
 * <p>
 * 部分业务代码依赖CommonStatusConstant
 *
 * @author houseme
 */
@Component
public class MessageCodeLoader {
    private static Logger logger = LoggerFactory.getLogger(MessageCodeLoader.class);

    public MessageCodeLoader() {
        init("conf/msg.properties");
    }

    public MessageCodeLoader(String resource) {
        init(resource);
    }

    public void init(String resource) {
        try {
            Properties p = new Properties();
            p.load(this.getClass().getClassLoader().getResourceAsStream(resource));
            for (Object obj : p.keySet()) {
                MessageUtil.put(Integer.parseInt(obj.toString()), p.getProperty(obj.toString()));
            }
        } catch (IOException e) {
            logger.error("init msg error", e);
        }
    }

    public static void main(String[] args) {
        MessageCodeLoader loader = new MessageCodeLoader();
        loader.init("conf/msg.properties");
        System.out.println(MessageUtil.getMsg(200));
    }

    public static Map<Integer, String> toMap(Class em) {
        Map<Integer, String> map = new HashMap<>();
        try {
            Method m = em.getMethod("getValue");
            Method m_ = em.getMethod("getDesc");
            Object[] objs = em.getEnumConstants();
            for (Object obj : objs) {
                Integer k = (Integer) m.invoke(obj);
                String v = (String) m_.invoke(obj);
                map.put(k, v);
            }
        } catch (NoSuchMethodException e) {
            logger.error("NoSuchMethodException.", e);
        } catch (InvocationTargetException e) {
            logger.error("InvocationTargetException.", e);
        } catch (Exception e) {
            logger.error("Exception.", e);
        }
        return map;
    }
}
