package com.lanren.huhu.partner.manager;

import com.alibaba.fastjson.JSON;
import com.lanren.huhu.partner.domain.UserAgent;
import com.lanren.huhu.partner.model.AgentResponse;
import com.lanren.huhu.partner.model.AgentRewardMessage;
import com.lanren.huhu.partner.result.Result;
import com.lanren.huhu.partner.service.UserAgentService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.ListOperations;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author chen
 */
@Component
public class AgentManager {
    private static Logger logger = LoggerFactory.getLogger(AgentManager.class);

    @Autowired
    UserAgentService userAgentService;
    @Autowired
    StringRedisTemplate redisTemplate;

    /***
     * * 获取代理商等级 1 总代, 2 大区, 3 省, 4 市
     * @param agentId
     * @return
     */
    public Result<AgentResponse> getAgentLevel(Integer agentId) {
        if (logger.isDebugEnabled()) {
            logger.info("UserAgentManager getLevel agentId:{},time:{}", agentId, LocalDateTime.now());
        }
        Result<AgentResponse> result = new Result<>();
        UserAgent userAgent = userAgentService.getOneByAgentId(agentId);
        if (null != userAgent) {
            result.setData(new AgentResponse(userAgent.getUserId(), userAgent.getAgentLevel()));
        } else {
            result.setCode(601);
        }
        return result;
    }

    public Result<String> divideReward() {
        ListOperations<String, String> ops = redisTemplate.opsForList();
        logger.info("message is: {}", ops.rightPop("agent_reward_redis_city_key"));
        return new Result<>();
    }

    public Result<String> pushReward() {
        ListOperations<String, String> ops = redisTemplate.opsForList();
        AgentRewardMessage agentRewardMessage = new AgentRewardMessage();
        agentRewardMessage.setRewardType(710);
        agentRewardMessage.setRechargeTime("2019-06-29 01:23:45");
        agentRewardMessage.setSourceUserId(2328);
        agentRewardMessage.setReferenceId("9999");
        agentRewardMessage.setAgentId(33);
        agentRewardMessage.setAgentReward(new BigDecimal(5));
        agentRewardMessage.setSettleState(-100);
        agentRewardMessage.setOrderType("taobao");
        agentRewardMessage.setOrderSn("507596802910534728");
        agentRewardMessage.setSubOrderSn("507596802910534728");
        agentRewardMessage.setOrderCommission(new BigDecimal("35.400000"));
        ops.leftPush("agent_reward_redis_city_key", JSON.toJSONString(agentRewardMessage));
        return new Result<>();
    }
}
