package com.lanren.huhu.partner.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.math.BigDecimal;
import lombok.Data;

@Data
@TableName(value = "user_agent")
public class UserAgent implements Serializable {
     @TableId(value = "agent_id", type = IdType.AUTO)
    private Integer agentId;

    @TableField(value = "user_id")
    private Integer userId;

    @TableField(value = "agent_name")
    private String agentName;

    @TableField(value = "agent_phone")
    private String agentPhone;

    @TableField(value = "agent_level")
    private Integer agentLevel;

    @TableField(value = "node_agent_level_name")
    private String nodeAgentLevelName;

    @TableField(value = "parent_agent_id")
    private Integer parentAgentId;

    @TableField(value = "parent_agent_list")
    private String parentAgentList;

    @TableField(value = "card_num")
    private Integer cardNum;

    @TableField(value = "card_activate_num")
    private Integer cardActivateNum;

    @TableField(value = "commission_rate")
    private BigDecimal commissionRate;

    @TableField(value = "pid")
    private String pid;

    @TableField(value = "jd_pid")
    private String jdPid;

    @TableField(value = "identity")
    private String identity;

    @TableField(value = "account_type")
    private Integer accountType;

    @TableField(value = "account")
    private String account;

    /**
     * 默认 99 无卡 100 有卡
     */
    @TableField(value = "have_card")
    private Integer haveCard;

    @TableField(value = "remark")
    private String remark;

    /**
     * 默认1 后台添加 2代理商邀请
     */
    @TableField(value = "register_from")
    private Integer registerFrom;

    /**
     * 邀请时间
     */
    @TableField(value = "invite_time")
    private Integer inviteTime;

    /**
     * 激活时间
     */
    @TableField(value = "active_time")
    private Integer activeTime;

    @TableField(value = "agent_state")
    private Integer agentState;

    @TableField(value = "created_at")
    private Integer createdAt;

    @TableField(value = "updated_at")
    private Integer updatedAt;

    @TableField(value = "deleted_at")
    private Integer deletedAt;

    /**
     * level1 id
     */
    @TableField(value = "agent_level_one")
    private Integer agentLevelOne;

    /**
     * level2 id
     */
    @TableField(value = "agent_level_two")
    private Integer agentLevelTwo;

    /**
     * level3 id
     */
    @TableField(value = "agent_level_three")
    private Integer agentLevelThree;

    /**
     * level4 id
     */
    @TableField(value = "agent_level_four")
    private Integer agentLevelFour;

    private static final long serialVersionUID = 1L;

    public static final String COL_USER_ID = "user_id";

    public static final String COL_AGENT_NAME = "agent_name";

    public static final String COL_AGENT_PHONE = "agent_phone";

    public static final String COL_AGENT_LEVEL = "agent_level";

    public static final String COL_NODE_AGENT_LEVEL_NAME = "node_agent_level_name";

    public static final String COL_PARENT_AGENT_ID = "parent_agent_id";

    public static final String COL_PARENT_AGENT_LIST = "parent_agent_list";

    public static final String COL_CARD_NUM = "card_num";

    public static final String COL_CARD_ACTIVATE_NUM = "card_activate_num";

    public static final String COL_COMMISSION_RATE = "commission_rate";

    public static final String COL_PID = "pid";

    public static final String COL_JD_PID = "jd_pid";

    public static final String COL_IDENTITY = "identity";

    public static final String COL_ACCOUNT_TYPE = "account_type";

    public static final String COL_ACCOUNT = "account";

    public static final String COL_HAVE_CARD = "have_card";

    public static final String COL_REMARK = "remark";

    public static final String COL_REGISTER_FROM = "register_from";

    public static final String COL_INVITE_TIME = "invite_time";

    public static final String COL_ACTIVE_TIME = "active_time";

    public static final String COL_AGENT_STATE = "agent_state";

    public static final String COL_CREATED_AT = "created_at";

    public static final String COL_UPDATED_AT = "updated_at";

    public static final String COL_DELETED_AT = "deleted_at";

    public static final String COL_AGENT_LEVEL_ONE = "agent_level_one";

    public static final String COL_AGENT_LEVEL_TWO = "agent_level_two";

    public static final String COL_AGENT_LEVEL_THREE = "agent_level_three";

    public static final String COL_AGENT_LEVEL_FOUR = "agent_level_four";
}