package com.lanren.huhu.partner.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import lombok.Data;

@Data
@TableName(value = "agent_reward")
public class AgentReward implements Serializable {
    /**
     * ID序号
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 代理商id
     */
    @TableField(value = "agent_id")
    private Integer agentId;

    /**
     * 代理商等级
     */
    @TableField(value = "agent_level")
    private Integer agentLevel;

    /**
     * 用户id
     */
    @TableField(value = "user_id")
    private Integer userId;

    /**
     * 奖励类型 40 开卡奖励 50 充值奖励 30 购买VIP会员 20 购买超级VIP会员
     */
    @TableField(value = "reward_type")
    private Integer rewardType;

    /**
     * 描述
     */
    @TableField(value = "reward_remark")
    private String rewardRemark;

    /**
     * 状态 100正常 99 错误
     */
    @TableField(value = "reward_status")
    private Integer rewardStatus;

    /**
     * 卡面值
     */
    @TableField(value = "money")
    private BigDecimal money;

    /**
     * 奖励金额
     */
    @TableField(value = "amount")
    private BigDecimal amount;

    /**
     * 充值支付金额或许充值卡卡号
     */
    @TableField(value = "cash_code")
    private String cashCode;

    /**
     * 用户充值时间
     */
    @TableField(value = "recharge_time")
    private LocalDateTime rechargeTime;

    /**
     * 可分红总额
     */
    @TableField(value = "commission_acount")
    private BigDecimal commissionAcount;

    /**
     * 比例值
     */
    @TableField(value = "commission_rate")
    private BigDecimal commissionRate;

    /**
     * 得到分红值
     */
    @TableField(value = "commission")
    private BigDecimal commission;

    /**
     * 相关id 产品或许充值卡相关id
     */
    @TableField(value = "reference_id")
    private Long referenceId;

    /**
     * 结算状态 100在路上 200预结算 300已结算 -100在路上已失效 -200预结算已失效 -300已结算扣回
     */
    @TableField(value = "settle_state")
    private Integer settleState;

    /**
     * 来源订单 与order表的order_id 关联
     */
    @TableField(value = "source_order")
    private String sourceOrder;

    /**
     * 源用户id
     */
    @TableField(value = "source_user_id")
    private Integer sourceUserId;

    /**
     * 源用户等级
     */
    @TableField(value = "source_user_level")
    private Integer sourceUserLevel;

    /**
     * 商品id
     */
    @TableField(value = "goods_id")
    private String goodsId;

    /**
     * 标题
     */
    @TableField(value = "title")
    private String title;

    /**
     * 订单类型
     */
    @TableField(value = "order_type")
    private String orderType;

    /**
     * 订单号
     */
    @TableField(value = "order_sn")
    private String orderSn;

    /**
     * 子订单号
     */
    @TableField(value = "sub_order_sn")
    private String subOrderSn;

    /**
     * 描述信息 比如充值卡或许充值卡信息
     */
    @TableField(value = "reward_extend")
    private String rewardExtend;

    @TableField(value = "created_at")
    private Long createdAt;

    @TableField(value = "updated_at")
    private Long updatedAt;

    @TableField(value = "deleted_at")
    private Long deletedAt;

    /**
     * 创建时间
     */
    @TableField(value = "create_time")
    private LocalDateTime createTime;

    private static final long serialVersionUID = 1L;

    public static final String COL_AGENT_ID = "agent_id";

    public static final String COL_AGENT_LEVEL = "agent_level";

    public static final String COL_USER_ID = "user_id";

    public static final String COL_REWARD_TYPE = "reward_type";

    public static final String COL_REWARD_REMARK = "reward_remark";

    public static final String COL_REWARD_STATUS = "reward_status";

    public static final String COL_MONEY = "money";

    public static final String COL_AMOUNT = "amount";

    public static final String COL_CASH_CODE = "cash_code";

    public static final String COL_RECHARGE_TIME = "recharge_time";

    public static final String COL_COMMISSION_ACOUNT = "commission_acount";

    public static final String COL_COMMISSION_RATE = "commission_rate";

    public static final String COL_COMMISSION = "commission";

    public static final String COL_REFERENCE_ID = "reference_id";

    public static final String COL_SETTLE_STATE = "settle_state";

    public static final String COL_SOURCE_ORDER = "source_order";

    public static final String COL_SOURCE_USER_ID = "source_user_id";

    public static final String COL_SOURCE_USER_LEVEL = "source_user_level";

    public static final String COL_GOODS_ID = "goods_id";

    public static final String COL_TITLE = "title";

    public static final String COL_ORDER_TYPE = "order_type";

    public static final String COL_ORDER_SN = "order_sn";

    public static final String COL_SUB_ORDER_SN = "sub_order_sn";

    public static final String COL_REWARD_EXTEND = "reward_extend";

    public static final String COL_CREATED_AT = "created_at";

    public static final String COL_UPDATED_AT = "updated_at";

    public static final String COL_DELETED_AT = "deleted_at";

    public static final String COL_CREATE_TIME = "create_time";
}