package com.lanren.huhu.partner.controller;

import com.lanren.huhu.partner.manager.AgentManager;
import com.lanren.huhu.partner.model.Agent;
import com.lanren.huhu.partner.model.AgentResponse;
import com.lanren.huhu.partner.result.Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.time.LocalDateTime;

/**
 * @author chen
 */
@RestController
@RequestMapping("/v1/agent")
public class AgentController {
    private static Logger logger = LoggerFactory.getLogger(AgentController.class);

    @Autowired
    AgentManager agentManager;

    @RequestMapping(value = "/level", method = RequestMethod.POST)
    public Result<AgentResponse> getAgentLevel(@RequestBody @Valid Agent agent, @RequestHeader HttpHeaders headers) {
        if (logger.isInfoEnabled()) {
            logger.info("AgentController getLevel agentId:{},header:{},time:{}", agent.getAgentId(), headers.keySet().toArray(), LocalDateTime.now());
        }
        return agentManager.getAgentLevel(agent.getAgentId());
    }

    @RequestMapping(value = "/reward/divide", method = RequestMethod.POST)
    public Result<String> divideReward(@RequestHeader HttpHeaders headers) {
        if (logger.isInfoEnabled()) {
            logger.info("AgentController divideReward, header:{},time:{}", headers.keySet().toArray(), LocalDateTime.now());
        }
        return agentManager.divideReward();
    }

    @RequestMapping(value = "/reward/push", method = RequestMethod.POST)
    public Result<String> pushReward(@RequestHeader HttpHeaders headers) {
        if (logger.isInfoEnabled()) {
            logger.info("AgentController divideReward, header:{},time:{}", headers.keySet().toArray(), LocalDateTime.now());
        }
        return agentManager.pushReward();
    }
}
