package com.lanren.huhu.partner;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.web.servlet.support.SpringBootServletInitializer;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.scheduling.annotation.EnableScheduling;

/**
 * @author houseme
 */
@SpringBootApplication
@EnableCaching
@EnableScheduling
public class PartnerApplication extends SpringBootServletInitializer {

    private static Logger logger = LoggerFactory.getLogger(PartnerApplication.class);

    public static void main(String[] args) {
        try {
            SpringApplication.run(PartnerApplication.class, args);
            logger.info("PartnerApplication >>>服务启动成功");
            Object lock = new Object();
            synchronized (lock) {
                try {
                    while (true) {
                        lock.wait();
                    }
                } catch (InterruptedException e) {
                    logger.error(e.getMessage(), e);
                }
            }


        } catch (Exception e) {
            logger.error("PartnerApplication>>服务启动失败", e);
            e.printStackTrace();
        }
    }

    @Override
    protected SpringApplicationBuilder configure(SpringApplicationBuilder builder) {
        return builder.sources(PartnerApplication.class);
    }
}
