package com.lanren.huhu.partner.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.lanren.huhu.partner.domain.PartnerAccount;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import javax.annotation.Resource;
import java.util.List;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.List;
import com.lanren.huhu.partner.domain.UserAgent;
import com.lanren.huhu.partner.dao.UserAgentMapper;
import com.lanren.huhu.partner.service.UserAgentService;

/**
 * @author chen
 */
@Service
public class UserAgentServiceImpl extends ServiceImpl<UserAgentMapper, UserAgent> implements UserAgentService{

    @Autowired
    UserAgentMapper userAgentMapper;

    @Override
    public int updateBatch(List<UserAgent> list) {
        return baseMapper.updateBatch(list);
    }
    @Override
    public int batchInsert(List<UserAgent> list) {
        return baseMapper.batchInsert(list);
    }
    @Override
    public int insertOrUpdate(UserAgent record) {
        return baseMapper.insertOrUpdate(record);
    }
    @Override
    public int insertOrUpdateSelective(UserAgent record) {
        return baseMapper.insertOrUpdateSelective(record);
    }

    @Override
    public UserAgent getOneByAgentId(Integer agentId) {
        QueryWrapper<UserAgent> queryWrapper = new QueryWrapper();
        queryWrapper.eq("agent_id", agentId)
                .le("agent_level", 4)
        ;
        return baseMapper.selectOne(queryWrapper);
    }

    @Override
    public UserAgent getOneByUserId(Integer userId) {
        QueryWrapper<UserAgent> queryWrapper = new QueryWrapper();
        queryWrapper.eq("user_id", userId).le("agent_level", 4);
        return baseMapper.selectOne(queryWrapper);
    }

    @Override
    public UserAgent getParentAgent(Integer agentId) {
        return userAgentMapper.getParentAgent(agentId);
    }


}
