package com.lanren.huhu.partner.model;

import com.lanren.huhu.partner.model.base.BaseModel;
import lombok.Data;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.ArrayList;

/**
 * @author chen
 * @title: User
 * @projectName partner
 * @description: 用户输入/输出
 * @package com.lanren.huhu.partner.model
 * @date 2019-06-2619:56
 */
@Data
public class User extends BaseModel {
    @NotNull(message = "userId 不能为空")
    @Min(value = 1, message = "userId 需要大于0")
    private int userId;

    private ArrayList<ParentPartner> partnerList;
    private ArrayList<ParentAgent> agentList;

}
