package com.lanren.huhu.partner.manager;

import com.lanren.huhu.partner.domain.PartnerAccount;
import com.lanren.huhu.partner.domain.UserAgent;
import com.lanren.huhu.partner.model.ParentAgent;
import com.lanren.huhu.partner.model.ParentPartner;
import com.lanren.huhu.partner.model.User;
import com.lanren.huhu.partner.result.Result;
import com.lanren.huhu.partner.service.PartnerAccountService;
import com.lanren.huhu.partner.service.UserAgentService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;

/**
 * @author houseme
 */
@Component
public class UserManager {
    private static Logger logger = LoggerFactory.getLogger(UserManager.class);

    @Autowired
    private PartnerAccountService partnerAccountService;

    @Autowired
    private UserAgentService userAgentService;

    /**
     * @description: 根据用户id, 查找一个用户的全部合伙人上级 和 代理商上级
     * @param user
     * @return Result<User>
     * @throws
     * @author chen
     * @date 2019-06-26 20:01
     */
    public Result<User> getRelation(User user) {
        setPartnerList(user);
        setAgentList(user);
        Result<User> result = new Result<User>();
        result.setData(user);
        return result;
    }

    /**
     * @description: 查找一个用户的全部合伙人上级, set到User对象的partnerList中
     * @param user
     * @author chen
     * @date 2019-06-26 20:37
     */
    private void setPartnerList(User user) {
        logger.info("begin setPartnerList for user: {} ......", user.getUserId());
        if (null == user.getPartnerList()) {
            ArrayList<ParentPartner> partnerList = new ArrayList<ParentPartner>();
            user.setPartnerList(partnerList);
        }
        /**
         * 无限找
         */
        int loopUserId = user.getUserId();
        while (true) {
            logger.info("now loop uid is {}", loopUserId);
            ParentPartner parentPartner = getParentPartner(loopUserId);
            if (null == parentPartner) {
                break;
            } else {
                logger.info("parent is {} ", parentPartner.getUserId());
                user.getPartnerList().add(parentPartner);
                loopUserId = parentPartner.getUserId();
            }
        }
        logger.info("setPartnerList for user: {} end", user.getUserId());
    }

    /**
     * @description: 查找一个用户的全部代理商上级 set到User对象的agentList中
     * @param user
     * @date 2019-06-27 11:16
     */
    private void setAgentList(User user) {
        logger.info("begin setAgentList for user: {} ......", user.getUserId());
        if (null == user.getAgentList()) {
            ArrayList<ParentAgent> agentList = new ArrayList<ParentAgent>();
            user.setAgentList(agentList);
        }
        /**
         * 无限找
         * 先无限找上级合伙人, 直到找到第一个是代理商的合伙人
         */
        int loopUserId = user.getUserId();
        while (true) {
            logger.info("now loop uid is {}", loopUserId);
            ParentPartner parentPartner = getParentPartner(loopUserId);
            if (null != parentPartner) {
                UserAgent userAgent = userAgentService.getOneByUserId(parentPartner.getUserId());
                if (null != userAgent) {
                    /**
                     * 然后开始 无限找 这个人的上级代理商
                     */
                    logger.info("find first agent({}) for user: {}", userAgent.getAgentId(), user.getUserId());
                    user.getAgentList().add(new ParentAgent(userAgent.getAgentId(), userAgent.getAgentLevel()));
                    logger.info("loop find parent agent start ......");
                    int loogAgentId = userAgent.getAgentId();
                    while (true) {
                        ParentAgent loopUserAgent = getParentAgent(loogAgentId);
                        if (null == loopUserAgent) {
                            break;
                        } else {
                            logger.info("parent agent is ", loopUserAgent.getAgentId());
                            user.getAgentList().add(new ParentAgent(loopUserAgent.getAgentId(), loopUserAgent.getLevel()));
                            loogAgentId = loopUserAgent.getAgentId();
                        }
                    }
                    logger.info("loop find parent agent end");
                    break;
                } else {
                    break;
                }
            } else {
                logger.info("parent is {} ", parentPartner.getUserId());
                user.getPartnerList().add(parentPartner);
                loopUserId = parentPartner.getUserId();
            }
        }
        logger.info("setAgentList for user: {} end", user.getUserId());
    }

    /**
     * 按userId查找上级合伙人的 userId 和 level
     * @param userId
     * @return
     */
    private ParentPartner getParentPartner(Integer userId) {
        PartnerAccount partnerAccount = partnerAccountService.getParentPartner(userId);
        ParentPartner parentPartner = null;
        if (null != partnerAccount) {
            int partnerLevel = partnerAccount.getIsSuperPartner() == 1 ? 30 : partnerAccount.getPartnerLevel();
            parentPartner = new ParentPartner(partnerAccount.getUserId(),partnerLevel);
        }
        return parentPartner;
    }

    /**
     * 按agentId 查找上级代理商的 agentId 和 level
     * @param agentId
     * @return
     */
    private ParentAgent getParentAgent(Integer agentId) {
        UserAgent userAgent = userAgentService.getParentAgent(agentId);
        ParentAgent parentAgent = null;
        if (null != userAgent) {
            int agentLevel = userAgent.getAgentLevel();
            parentAgent = new ParentAgent(userAgent.getAgentId(), agentLevel);
        }
        return parentAgent;
    }
}
