package com.lanren.huhu.partner.manager;

import com.lanren.huhu.partner.domain.UserAgent;
import com.lanren.huhu.partner.model.AgentRsp;
import com.lanren.huhu.partner.model.PartnerRsp;
import com.lanren.huhu.partner.result.Result;
import com.lanren.huhu.partner.service.UserAgentService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.time.LocalDateTime;

/**
 * @author chen
 */
@Component
public class UserAgentManager {
    private static Logger logger = LoggerFactory.getLogger(UserAgentManager.class);

    @Autowired
    UserAgentService userAgentService;

    /***
     * * 获取代理商等级 1 总代, 2 大区, 3 省, 4 市
     * @param agentId
     * @return
     */
    public Result<AgentRsp> getAgentLevel(Integer agentId) {
        if (logger.isDebugEnabled()) {
            logger.info("UserAgentManager getLevel agentId:{},time:{}", agentId, LocalDateTime.now());
        }
        Result<AgentRsp> result = new Result<>();
        UserAgent userAgent = userAgentService.getOneByAgentId(agentId);
        int agentLevel;
        if (null != userAgent) {
            agentLevel = userAgent.getAgentLevel();
        } else {
            agentLevel = -1;
            result.setCode(601);
        }
        result.setData(new AgentRsp(agentLevel));
        return result;
    }
}
