package com.lanren.huhu.partner.manager;

import com.lanren.huhu.partner.domain.PartnerAccount;
import com.lanren.huhu.partner.model.PartnerRsp;
import com.lanren.huhu.partner.result.Result;
import com.lanren.huhu.partner.service.PartnerAccountService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.time.LocalDateTime;

/**
 * @author houseme
 * @date 2019-06-26 10:56
 * @Project partner
 * @Package com.lanren.huhu.partner.manager
 * @File: PartnerAccountManager
 */
@Component
public class PartnerAccountManager {
    private static Logger logger = LoggerFactory.getLogger(PartnerAccountManager.class);

    @Autowired
    private PartnerAccountService partnerAccountService;

    /***
     * 获取合伙人账户信息
     * @param userId
     * @return
     */
    public Result<PartnerAccount> findByUserId(Integer userId) {
        Result<PartnerAccount> result = new Result<>();
        if (logger.isDebugEnabled()) {
            logger.info("PartnerAccountManager findByUserId userId:{},time:{}", userId, LocalDateTime.now());
        }
        PartnerAccount partnerAccount = partnerAccountService.getOneByUserId(userId);
        logger.info("findByUserId {}", partnerAccount);
        result.setData(partnerAccount);
        return result;
    }

    /***
     * 获取合伙人等级 10 普通, 20 高级, 30 超级
     * @param userId
     * @return
     */
    public Result<PartnerRsp> getPartnerLevel(Integer userId) {
        if (logger.isDebugEnabled()) {
            logger.info("PartnerAccountManager getPartnerLevel userId:{},time:{}", userId, LocalDateTime.now());
        }
        Result<PartnerRsp> result = new Result<>();
        int partnerLevel;
        PartnerAccount partnerAccount = partnerAccountService.getOneByUserId(userId);
        if (null != partnerAccount) {
            if (partnerAccount.getIsSuperPartner() == 1) {
                partnerLevel = 30;
            } else {
                partnerLevel = partnerAccount.getPartnerLevel();
            }
        } else {
            partnerLevel = -1;
            result.setCode(60404);
        }
        result.setData(new PartnerRsp(partnerLevel));
        return result;
    }
}
