package com.lanren.huhu.partner.dao;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.lanren.huhu.partner.domain.UserAgent;
import java.util.List;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

@Mapper
public interface UserAgentMapper extends BaseMapper<UserAgent> {
    int updateBatch(List<UserAgent> list);

    int batchInsert(@Param("list") List<UserAgent> list);

    int insertOrUpdate(UserAgent record);

    int insertOrUpdateSelective(UserAgent record);

    /**
     * 按agentId查找上级 UserAgent
     * @param agentId
     * @return
     */
    @Select("SELECT b.*\n" +
            "FROM user_agent a \n" +
            "JOIN user_agent b on a.parent_agent_id=b.agent_id\n" +
            "WHERE a.agent_id=#{agentId} and b.agent_level<=4")
    UserAgent getParentAgent(Integer agentId);
}