package com.lanren.huhu.partner.dao;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.lanren.huhu.partner.domain.PartnerAccount;
import java.util.List;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

@Mapper
public interface PartnerAccountMapper extends BaseMapper<PartnerAccount> {
    int updateBatch(List<PartnerAccount> list);

    int batchInsert(@Param("list") List<PartnerAccount> list);

    int insertOrUpdate(PartnerAccount record);

    int insertOrUpdateSelective(PartnerAccount record);

    /**
     * 按uid查找上级 PartnerAccount
     * @param userId
     * @return
     */
    @Select("SELECT b.* \n" +
            "FROM partner_invite_relation a\n" +
            "JOIN partner_account b on a.invite_user_id=b.user_id\n" +
            "WHERE a.user_id=#{userId}")
    PartnerAccount getParentByUserId(Integer userId);
}