package com.lanren.huhu.partner.controller;

import com.lanren.huhu.partner.domain.PartnerAccount;
import com.lanren.huhu.partner.manager.PartnerAccountManager;
import com.lanren.huhu.partner.model.Partner;
import com.lanren.huhu.partner.model.PartnerRsp;
import com.lanren.huhu.partner.result.Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.validation.BindingResult;
import org.springframework.validation.ObjectError;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;


/**
 * @Author houseme
 * @Date 2019-06-26 11:00
 * @Project partner
 * @Package com.lanren.huhu.partner.controller
 * @File: PartnerController
 */
@RestController
@RequestMapping("/v1/partner")
public class PartnerController {
    private static Logger logger = LoggerFactory.getLogger(PartnerController.class);

    @Autowired
    private PartnerAccountManager partnerAccountManager;

    @RequestMapping(value = "/{id}", method = RequestMethod.GET)
    public Result<PartnerAccount> one(@PathVariable("id") Integer id, @RequestHeader HttpHeaders headers) {
        if (logger.isInfoEnabled()) {
            logger.info("partner one userId:{},header:{},time:{}", id,
                    headers.entrySet().toString(),
                    LocalDateTime.now());
        }
        return partnerAccountManager.findByUserId(id);
    }

    @RequestMapping(value = "/userId/{id}", method = RequestMethod.POST)
    public Result<PartnerAccount> getOne(@PathVariable("id") Integer id,
                                         @RequestBody @Validated Partner partner, @RequestHeader HttpHeaders headers,
                                         BindingResult result) {
        if (logger.isInfoEnabled()) {
            List<String> list = new ArrayList<>();
            if (result.hasErrors()) {
                List<ObjectError> errors = result.getAllErrors();
                for (ObjectError objectError : errors) {
                    list.add(objectError.getDefaultMessage());
                }
                Result<PartnerAccount> objectResult = new Result<>();
                objectResult.setMessage(list.toString());
                return objectResult;
            }
            logger.info("partner one userId:{},header:{},time:{}", id,
                    headers.entrySet().toString(),
                    LocalDateTime.now());
        }
        return partnerAccountManager.findByUserId(id);
    }


    @RequestMapping(value = "/level", method = RequestMethod.POST)
    public Result<PartnerRsp> getPartnerLevel(@RequestBody @Valid Partner partner, @RequestHeader HttpHeaders headers) {
        if (logger.isInfoEnabled()) {
            logger.info("getPartnerLevel userId:{ },header:{},time:{}", partner.getUserId(), headers.keySet().toArray(), LocalDateTime.now());
        }
        return partnerAccountManager.getPartnerLevel(partner.getUserId());
    }
}
