package com.lanren.huhu.partner.config;

import com.alibaba.fastjson.JSON;
import com.lanren.huhu.partner.constants.CommonStatusConstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

/**
 * @author houseme
 * @date 2019-04-02 21:31
 * Project partner
 * Package com.lanren.huhu.partner
 * File: AuthenticationInterceptor
 */
public class AuthenticationInterceptor extends HandlerInterceptorAdapter {

    private final Logger logger = LoggerFactory.getLogger(AuthenticationInterceptor.class);


    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        long startTime = System.currentTimeMillis();
        request.setAttribute("startTime", startTime);

        HandlerMethod handlerMethod = (HandlerMethod) handler;
        logger.info("AuthenticationInterceptor Method ==>{}", handlerMethod.getMethod().getName());
        logger.info("AuthenticationInterceptor HandlerMethod ==>{}", handlerMethod.getBeanType().getName());


        return true;
    }

    private void returnMsg(HttpServletResponse response) throws IOException {
        Map<String, Object> map = new HashMap<>();
        map.put("code", CommonStatusConstant.SESSION_TIMEOUT.getValue());
        map.put("msg", CommonStatusConstant.SESSION_TIMEOUT.getDesc());
        response.setHeader("Content-type", "application/json;charset=UTF-8");
        logger.info("msg :{}", CommonStatusConstant.SESSION_TIMEOUT.getDesc());
        response.getWriter().write(JSON.toJSONString(map));
    }
}
