package com.lanren.huhu.partner.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.lanren.huhu.partner.dao.OrderTaobaoJdCommissionMapper;
import com.lanren.huhu.partner.domain.OrderTaobaoJdCommission;
import com.lanren.huhu.partner.model.OrderParam;
import com.lanren.huhu.partner.service.OrderTaobaoJdCommissionService;
import org.springframework.stereotype.Service;

import java.util.Iterator;
import java.util.List;
import java.util.Set;

/**
 * @author houseme
 * @date 2019-07-01 14:43
 * @Project partner
 * @Package ${PACKAGE_NAME}
 * @File: ${NAME}
 */
@Service
public class OrderTaobaoJdCommissionServiceImpl extends ServiceImpl<OrderTaobaoJdCommissionMapper, OrderTaobaoJdCommission> implements OrderTaobaoJdCommissionService {

    @Override
    public int updateBatch(List<OrderTaobaoJdCommission> list) {
        return baseMapper.updateBatch(list);
    }

    @Override
    public int batchInsert(List<OrderTaobaoJdCommission> list) {
        return baseMapper.batchInsert(list);
    }

    @Override
    public int insertOrUpdate(OrderTaobaoJdCommission record) {
        return baseMapper.insertOrUpdate(record);
    }

    @Override
    public int insertOrUpdateSelective(OrderTaobaoJdCommission record) {
        return baseMapper.insertOrUpdateSelective(record);
    }

    @Override
    public List<OrderTaobaoJdCommission> selectListByOrderParamSet(Set<OrderParam> orderParamSet) {
        QueryWrapper<OrderTaobaoJdCommission> wrapper = new QueryWrapper<OrderTaobaoJdCommission>();
        Iterator<OrderParam> iterator = orderParamSet.iterator();
        for (int idx = 0; idx < orderParamSet.size(); idx++) {
            OrderParam order = iterator.next();
            wrapper.nested(i -> i.eq("type", order.getOrderType())
                    .eq("order_sn", order.getOrderSn()));
            if (idx < orderParamSet.size() - 1) {
                wrapper.or();
            }
        }
        return baseMapper.selectList(wrapper);
    }
}

