package com.lanren.huhu.partner.schedule;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.lanren.huhu.partner.constants.Constants;
import com.lanren.huhu.partner.domain.*;
import com.lanren.huhu.partner.model.*;
import com.lanren.huhu.partner.service.*;
import com.lanren.huhu.partner.util.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.*;

import static com.lanren.huhu.partner.constants.Constants.NEW_SETTLE_RULE_TIME;
import static org.springframework.util.StringUtils.isEmpty;

/**
 * @author chen
 * @title: AgentSettleTask
 * @projectName partner
 * @description: 代理商结算
 * @package com.lanren.huhu.partner.schedule
 * @date 2019-07-23 10:31
 */
@Component
public class AgentSettleTask {
    private static Logger logger = LoggerFactory.getLogger(AgentSettleTask.class);
    private static final int PAGE_SIZE = 1000;
    private static final BigDecimal ZERO = new BigDecimal(0);

    @Autowired
    AgentRewardService agentRewardService;
    @Autowired
    OrdersActiveService ordersActiveService;
    @Autowired
    OrderTaobaoJdCommissionService orderTaobaoJdCommissionService;
    @Autowired
    OrderTaobaoJdGoodsCommissionService orderTaobaoJdGoodsCommissionService;
    @Autowired
    DataSourceTransactionManager dataSourceTransactionManager;
    @Autowired
    TransactionDefinition transactionDefinition;
    @Autowired
    AgentAccountService agentAccountService;
    @Autowired
    AgentIncomeSummaryService agentIncomeSummaryService;
    @Autowired
    AgentAccountLogService agentAccountLogService;
    @Autowired
    AgentBankCardService agentBankCardService;
    @Autowired
    AgentSalaryService agentSalaryService;
    @Autowired
    AgentExpandDailyService agentExpandDailyService;

    @Async
    public void runScheduledTask() {
        logger.info("run AgentSettleTask");
        try {
            long input = DateUtils.getLastMonth1stTimestamp(System.currentTimeMillis());
            long beginTs = DateUtils.getMonth1stTimestamp(input) / 1000L;
            long endTs  = DateUtils.getMonthLastTimestamp(input) / 1000L;
            updateAll(beginTs, endTs);
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
        }
        logger.info("run AgentSettleTask done");
    }

    private void updateAll(long beginTs, long endTs) {
//        updateOrderCommission(beginTs, endTs, 0, 0);
        doSettle(beginTs, endTs);
    }

    private void doSettle(long beginTs, long endTs) {
        AgentSettle errAgentSettle = null;
        try {
            int cnt = 0;
            while (true) {
                int pageNo = 1;
                Page<AgentSettle> page = new Page<AgentSettle>(pageNo, PAGE_SIZE);
                page.setOptimizeCountSql(false);
                page.setSearchCount(false);
                IPage<AgentSettle> ipage = agentRewardService.selectAgentSettlePageByTs(page, beginTs, endTs);
                List<AgentSettle> agentSettleList = ipage.getRecords();
                if (agentSettleList != null && agentSettleList.size() > 0) {
                    for (AgentSettle agentSettle : agentSettleList) {
                        try {
                            updateTax(agentSettle);
                            errAgentSettle = agentSettle;
                            if (agentSettle != null) {
                                if (!doDbUpdate(agentSettle, beginTs, endTs)) {
                                    logger.error("doDbUpdate failed for agent {}", agentSettle.getAgentId());
                                }
                            }
                        } catch (Exception e) {
                            logger.error(e.getMessage(), e);
                        }
                        cnt++;
                    }
                } else {
                    break;
                }
            }
            logger.info("cnt is {}", cnt);
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            logger.error("errAgentSettle is {}", errAgentSettle);
        }
    }

    private void updateTax(AgentSettle agentSettle) {
        BigDecimal tax = BigDecimal.ZERO;
        agentSettle.setTax(tax);
    }

    /**
     * 自购省和分享赚的奖励金额 需要根据最终的实际原始佣金 重新计算
     * @param beginTs
     * @param endTs
     */
    private void updateOrderCommission(long beginTs, long endTs, int runType, int agentId) {
        AgentReward errAgentReward = null;
        try {
            int pageNo = 1;
            int total = 0;
            int totalPage = 0;
            int cnt = 0;
            while (true) {
                Page<AgentReward> page = new Page<AgentReward>(pageNo, PAGE_SIZE);
                page.setOptimizeCountSql(false);
                IPage<AgentReward> ipage;
                if (runType == 0) {
                    ipage = agentRewardService.selectOrderRewardPageByTs(page, beginTs, endTs);
                } else {
                    ipage = agentRewardService.selectOrderRewardPageByTsAndAgentId(page, beginTs, endTs, agentId);
                }
                if (total == 0) {
                    total = (int) ipage.getTotal();
                    totalPage = total % PAGE_SIZE == 0 ? total / PAGE_SIZE : total / PAGE_SIZE + 1;
                    logger.info("totalPage is {} ", totalPage);
                }
                List<AgentReward> agentRewardList = ipage.getRecords();
                List<AgentReward> updateCommisionList = new ArrayList<AgentReward>();
                List<AgentReward> update2FailedList = new ArrayList<AgentReward>();
                if (agentRewardList != null && agentRewardList.size() > 0) {
                    /**
                     * 加载ordersActiveMap orderMap subOrderMap
                     */
                    Set<OrderParam> orderParamsSet = generateOrderParamsSet(agentRewardList);
                    Set<SubOrderParam> subOrderParamsSet = generateSubOrderParamsSet(agentRewardList);
                    Map<OrderParam, OrdersActive> ordersActiveMap = generateOrdersActiveMap(orderParamsSet);
                    Map<OrderParam, OrderTaobaoJdCommission> orderMap = generateOrderMap(orderParamsSet);
                    Map<SubOrderParam, OrderTaobaoJdGoodsCommission> subOrderMap = generateSubOrderMap(subOrderParamsSet);
                    /**
                     * 循环处理每条奖励
                     */
                    for (AgentReward agentReward : agentRewardList) {
                        try {
                            errAgentReward = agentReward;
                            /**
                             * 自购省奖励: reward_type: 300 或 750, settle_state > 0 且 != 300
                             * 需要根据订单号查找最终的真实的原始佣金 并 按比例快照重新计算奖励金额,
                             * 更新字段: all_money_ori cash commission_account
                             * 如果订单失效: 更新settle_state, all_money_ori/cash/commission_account 抹平, 跳过处理, 循环到下一条
                             */
                            if ( (agentReward.getRewardType() == Constants.AGENT_REWARD_TYPE_PURCHASE || agentReward.getRewardType() == Constants.AGENT_REWARD_TYPE_SELF_ORDER)
                                    && agentReward.getSettleState() != Constants.SETTLE_STATE_DONE) {
                                if (isEmpty(agentReward.getOrderType()) || isEmpty(agentReward.getOrderSn())) {
                                    /**
                                     * 历史数据: 没有记录订单号 或者 没有记录比例 不更新奖励金额
                                     */
                                    continue;
                                } else if (agentReward.getSettleState() < 0) {
                                    continue;
                                } else if (agentReward.getAmount().compareTo(BigDecimal.ZERO) == 0) {
                                    /**
                                     * amout为0的 跳过不处理
                                     * 红包兑换的奖励 状态是有效 奖励金额为0
                                     */
                                    continue;
                                } else {
                                    /**
                                     * 有订单号 和 比例快照 可以更新金额
                                     */
                                    OrderParam orderParam = new OrderParam();
                                    orderParam.setOrderType(agentReward.getOrderType());
                                    orderParam.setOrderSn(agentReward.getOrderSn());
                                    OrdersActive ordersActive = ordersActiveMap.get(orderParam);
                                    OrderTaobaoJdCommission order = orderMap.get(orderParam);
                                    if (null == ordersActive || null == order) {
                                        /**
                                         * 如果没有找到active 或者 没有找到commission
                                         * 不更新奖励金额
                                         */
                                        continue;
                                    } else {
                                        /**
                                         * 订单状态只有三种: -3, 1, 3
                                         */
                                        if (order.getStatus() == Constants.ORDER_STATE_FAILED) {
                                            /**
                                             * 订单失效 订单付款 跳过, 处理下一条奖励
                                             */
                                            add2UpdateReward2Failed(agentReward, update2FailedList);
                                        } else if (order.getStatus() == Constants.ORDER_STATE_PAID) {
                                            /**
                                             * 订单还是付款状态 更新奖励时间 下个月再处理
                                             */
                                            long newRechargeTime = DateUtils.getNextMonth1stTimestamp(agentReward.getRechargeTime().getTime());
                                            agentReward.setRechargeTime(new Date(newRechargeTime));
                                            agentReward.setSettleTime(new Date(newRechargeTime));
                                            agentReward.setUpdatedAt(System.currentTimeMillis() / 1000L);
                                            agentRewardService.updateById(agentReward);
                                        } else if (order.getStatus() == Constants.ORDER_STATE_SETTLED) {
                                            /**
                                             * 订单结算 更新金额
                                             */
                                            if (ordersActive.getIsForNew() == 1) {
                                                /**
                                                 * 新人专享订单 不给合伙人奖励 跳过
                                                 */
                                                add2UpdateReward2Failed(agentReward, update2FailedList);
                                            } else {
                                                /**
                                                 * 正常订单 更新原始佣金
                                                 * all_money_ori: 原始佣金
                                                 * cash: all_money_ori 乘以 ratio_all中的每个比例
                                                 * commission_account: cash 乘以 commission_rate
                                                 */
                                                add2UpdateRewardCommission(agentReward, order.getAllMoney(), updateCommisionList);
                                            }
                                        }
                                    }
                                }
                            }
                            /**
                             * 分享赚订单: 按子订单号更新奖励金额 60 或 760
                             */
                            if ( (agentReward.getRewardType() == Constants.AGENT_REWARD_TYPE_SHARE || agentReward.getRewardType() == Constants.AGENT_REWARD_TYPE_SHARE_ORDER)
                                    && agentReward.getSettleState() > 0
                                    && agentReward.getSettleState() != Constants.SETTLE_STATE_DONE) {
                                if (isEmpty(agentReward.getOrderType()) || isEmpty(agentReward.getOrderSn()) || isEmpty(agentReward.getSubOrderSn())) {
                                    /**
                                     * 历史数据: 没有记录子订单号 或者 没有记录比例 不更新奖励金额
                                     */
                                    continue;
                                } else if (agentReward.getSettleState() < 0) {
                                    continue;
                                } else if (agentReward.getAmount().compareTo(BigDecimal.ZERO) == 0) {
                                    /**
                                     * amout为0的 跳过不处理
                                     * 红包兑换的奖励 状态是有效 奖励金额为0
                                     */
                                    continue;
                                } else {
                                    /**
                                     * 有订单号 和 比例快照 可以更新金额
                                     */
                                    SubOrderParam subOrderParam = new SubOrderParam();
                                    subOrderParam.setOrderType(agentReward.getOrderType());
                                    subOrderParam.setOrderSn(agentReward.getOrderSn());
                                    subOrderParam.setSubOrderSn(agentReward.getSubOrderSn());
                                    OrderTaobaoJdGoodsCommission subOrder = subOrderMap.get(subOrderParam);
                                    if (null == subOrder) {
                                        /**
                                         * 如果没有找到子订单
                                         * 不更新奖励金额
                                         */
                                        continue;
                                    } else {
                                        /**
                                         * 订单状态只有三种: -3, 1, 3
                                         */
                                        if (subOrder.getOrderState() == Constants.ORDER_STATE_FAILED) {
                                            /**
                                             * 订单失效 订单付款 跳过, 处理下一条奖励
                                             */
                                            add2UpdateReward2Failed(agentReward, update2FailedList);
                                        } else if (subOrder.getOrderState() == Constants.ORDER_STATE_PAID) {
                                            /**
                                             * 订单还是付款状态 更新奖励时间 下个月再处理
                                             */
                                            long newRechargeTime = DateUtils.getNextMonth1stTimestamp(agentReward.getRechargeTime().getTime());
                                            agentReward.setRechargeTime(new Date(newRechargeTime));
                                            agentReward.setSettleTime(new Date(newRechargeTime));
                                            agentReward.setUpdatedAt(System.currentTimeMillis() / 1000L);
                                            agentRewardService.updateById(agentReward);
                                        } else if (subOrder.getOrderState() == Constants.ORDER_STATE_SETTLED) {
                                            /**
                                             * 正常订单 更新原始佣金
                                             * all_money_ori: 原始佣金
                                             * cash: all_money_ori 乘以 ratio_all中的每个比例
                                             * commission_account: cash 乘以 commission_rate
                                             */
                                            add2UpdateRewardCommission(agentReward, subOrder.getAllMoney(), updateCommisionList);
                                        }
                                    }
                                }
                            }
                        } catch (Exception e) {
                            logger.error(e.getMessage(), e);
                        }
                        cnt++;
                    }
                }
                if (updateCommisionList.size() > 0) {
                    agentRewardService.updateBatch(updateCommisionList);
                }
                if (update2FailedList.size() > 0) {
                    agentRewardService.updateBatch(update2FailedList);
                }
                if (pageNo >= totalPage) {
                    break;
                }
                pageNo++;
            }
            logger.info("cnt is {}", cnt);
        } catch (Exception e) {
            logger.error(e.getMessage(),e);
            logger.error("errAgentReward is {}", errAgentReward);
        }
    }

    private Map<SubOrderParam, OrderTaobaoJdGoodsCommission> generateSubOrderMap(Set<SubOrderParam> subOrderParamsSet) {
        Map<SubOrderParam, OrderTaobaoJdGoodsCommission> map = new HashMap<SubOrderParam, OrderTaobaoJdGoodsCommission>();
        List<OrderTaobaoJdGoodsCommission> list = orderTaobaoJdGoodsCommissionService.selectListBySubOrderParamsSet(subOrderParamsSet);
        for (OrderTaobaoJdGoodsCommission subOrder : list) {
            SubOrderParam key = new SubOrderParam();
            key.setOrderType(subOrder.getType());
            key.setOrderSn(subOrder.getOrderSn());
            key.setSubOrderSn(subOrder.getSubOrderSn());
            map.put(key, subOrder);
        }
        return map;
    }

    private Map<OrderParam, OrderTaobaoJdCommission> generateOrderMap(Set<OrderParam> orderParamsSet) {
        Map<OrderParam, OrderTaobaoJdCommission> map = new HashMap<OrderParam, OrderTaobaoJdCommission>();
        List<OrderTaobaoJdCommission> list = orderTaobaoJdCommissionService.selectListByOrderParamSet(orderParamsSet);
        for (OrderTaobaoJdCommission order : list) {
            OrderParam key = new OrderParam();
            key.setOrderType(order.getType());
            key.setOrderSn(order.getOrderSn());
            map.put(key, order);
        }
        return map;
    }

    private Map<OrderParam, OrdersActive> generateOrdersActiveMap(Set<OrderParam> orderParamSet) {
        Map<OrderParam, OrdersActive> map = new HashMap<OrderParam, OrdersActive>();
        List<OrdersActive> list = ordersActiveService.selectListByOrderParamSet(orderParamSet);
        for (OrdersActive order : list) {
            OrderParam key = new OrderParam();
            key.setOrderType(order.getType());
            key.setOrderSn(order.getOrderSn());
            map.put(key, order);
        }
        return map;
    }

    private Set<SubOrderParam> generateSubOrderParamsSet(List<AgentReward> agentRewardList) {
        Set<SubOrderParam> set = new HashSet<SubOrderParam>();
        for (AgentReward reward : agentRewardList) {
            SubOrderParam orderParam = new SubOrderParam();
            orderParam.setOrderType(reward.getOrderType());
            orderParam.setOrderSn(reward.getOrderSn());
            orderParam.setSubOrderSn(reward.getSubOrderSn());
            set.add(orderParam);
        }
        return set;
    }

    private Set<OrderParam> generateOrderParamsSet(List<AgentReward> agentRewardList) {
        Set<OrderParam> set = new HashSet<OrderParam>();
        for (AgentReward reward : agentRewardList) {
            OrderParam orderParam = new OrderParam();
            orderParam.setOrderType(reward.getOrderType());
            orderParam.setOrderSn(reward.getOrderSn());
            set.add(orderParam);
        }
        return set;
    }

    private void add2UpdateRewardCommission(AgentReward agentReward, BigDecimal allMoney, List<AgentReward> updateCommisionList) {
        String ratioAllStr = "";
        try {
            BigDecimal allMoneyOri;
            if (agentReward.getDepositeTailRate().compareTo(BigDecimal.ZERO) > 0) {
                allMoneyOri = allMoney.multiply(agentReward.getDepositeTailRate());
            } else {
                allMoneyOri = allMoney;
            }
            agentReward.setAllMoneyOri(allMoneyOri);
            ratioAllStr = agentReward.getRatioAll().replaceAll("[\\[\\]\"]", "");
            /**
             * 时间点之前的 需要乘比例数组 之后 再乘commission_rate
             * 时间点之后的 直接乘commission_rate
             */
            if (agentReward.getRechargeTime().compareTo(NEW_SETTLE_RULE_TIME) < 0) {
                if (!isEmpty(ratioAllStr)) {
                    String[] strs = ratioAllStr.split(",");
                    if (strs.length > 0) {
                        BigDecimal cash = allMoneyOri;
                        for (String s : strs) {
                            BigDecimal ratio = new BigDecimal(s);
                            cash = cash.multiply(ratio);
                        }
                        agentReward.setMoney(cash);
                        agentReward.setCommissionAcount(cash);
                        BigDecimal commission = cash.multiply(agentReward.getCommissionRate());
                        agentReward.setAmount(commission);
                        agentReward.setCommission(commission);
                        agentReward.setSettleState(Constants.SETTLE_STATE_DONE);
                        agentReward.setUpdatedAt(System.currentTimeMillis() / 1000L);
                        updateCommisionList.add(agentReward);
                    }
                }
            } else {
                agentReward.setMoney(allMoneyOri);
                agentReward.setCommissionAcount(allMoneyOri);
                BigDecimal commission = allMoneyOri.multiply(agentReward.getCommissionRate());
                agentReward.setAmount(commission);
                agentReward.setCommission(commission);
                agentReward.setSettleState(Constants.SETTLE_STATE_DONE);
                agentReward.setUpdatedAt(System.currentTimeMillis() / 1000L);
                updateCommisionList.add(agentReward);
            }
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            logger.error("ratioAllStr is {}", ratioAllStr);
        }
    }

    /**
     * money 面额(message里, 需要上供的代理商自己获得的奖励)
     * commission_account 面额
     * cash_code 支付金额
     * amount 奖励金额
     * commission 奖励金额
     */
    private void add2UpdateReward2Failed(AgentReward agentReward, List<AgentReward> update2FailedList) {
        if (agentReward.getAmount().compareTo(BigDecimal.ZERO) >= 0) {
            agentReward.setMoney(ZERO);
            agentReward.setCommissionAcount(ZERO);
            agentReward.setAmount(ZERO);
            agentReward.setCommission(ZERO);
        }
        agentReward.setAllMoneyOri(ZERO);
        agentReward.setCashCode("0");
        if (agentReward.getSettleState() > 0) {
            agentReward.setSettleState(agentReward.getSettleState() * -1);
        }
        agentReward.setUpdatedAt(System.currentTimeMillis() / 1000L);
        update2FailedList.add(agentReward);
    }

    public boolean doOneAgentSettle(Integer agentId) {
        long input = DateUtils.getLastMonth1stTimestamp(System.currentTimeMillis());
        long beginTs = DateUtils.getMonth1stTimestamp(input) / 1000L;
        long endTs  = DateUtils.getMonthLastTimestamp(input) / 1000L;
        AgentSettle errAgentSettle = null;
        try {
            updateOrderCommission(beginTs, endTs, 1, agentId);
            AgentSettle agentSettle = agentRewardService.selectAgentSettleByTsAndAgentId(beginTs, endTs, agentId);
            /**
             * 更新税
             */
            errAgentSettle = agentSettle;
            if (agentSettle != null) {
                updateTax(agentSettle);
                return doDbUpdate(agentSettle, beginTs, endTs);
            } else {
                logger.info("没有待奖励记录 跳过不处理, 代理商{}", agentId);
                return true;
            }
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            logger.error("agentId is {}, errAgentSettle is {}", agentId, errAgentSettle);
            return false;
        }
    }

    private boolean doDbUpdate(AgentSettle agentSettle, long beginTs, long endTs) {
        TransactionStatus transactionStatus = null;
        try {
            /**
             * 开启事务
             */
            transactionStatus = dataSourceTransactionManager.getTransaction(transactionDefinition);

            /**
             * 获取合伙人账户 锁定行
             */
            AgentAccount agentAccount = agentAccountService.getOneByUserIdForUpdate(agentSettle.getAgentId());
            /**
             * 插入变更记录
             */
            AgentSalary agentSalary = insertAgentSalary(agentSettle, beginTs);
            insertIntoAgentAccountLog(agentSettle, agentAccount, agentSalary, beginTs);
            updateAgentAccount(agentSettle, agentAccount);
            updateAgentRewardStatus(agentSettle.getAgentId(), beginTs, endTs);
            insertAgentIncomeSummary(agentSettle, beginTs, endTs);
            /**
             * 提交事务
             */
            dataSourceTransactionManager.commit(transactionStatus);
//            dataSourceTransactionManager.rollback(transactionStatus);
            return true;
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            /**
             * 回滚事务
             */
            if (transactionStatus != null) {
                logger.info("do settle failed, rollback");
                dataSourceTransactionManager.rollback(transactionStatus);
            }
            return false;
        }
    }

    private AgentSalary insertAgentSalary(AgentSettle agentSettle, long beginTs) {
        Date now = new Date(beginTs * 1000L);
        int yeartime = Integer.parseInt(DateUtils.getYear(now));
        int monthtime = Integer.parseInt(DateUtils.getMonth(now));
        AgentBankCard agentBankCard = agentBankCardService.getOneByAgentId(agentSettle.getAgentId());
        AgentSalary agentSalary = new AgentSalary();
        agentSalary.setUserId(agentSettle.getUserId());
        agentSalary.setAgentId(agentSettle.getAgentId());
        agentSalary.setYeartime(yeartime);
        agentSalary.setMonthtime(monthtime);
        agentSalary.setMonth(DateUtils.format(now, "yyyy-MM"));
        agentSalary.setBalance(agentSettle.getBalance());
        agentSalary.setOpencardBalance(agentSettle.getOpencardBalance());
        agentSalary.setRechargeBalance(agentSettle.getRechargeBalance());
        agentSalary.setUpgradeBalance(agentSettle.getUpgradeBalance());
        agentSalary.setUpgradeSuperBalance(agentSettle.getUpgradeSuperBalance());
        agentSalary.setTaxBalance(agentSettle.getTax());
        agentSalary.setShareBalance(agentSettle.getShareBalance());
        agentSalary.setZigoushengBalance(agentSettle.getZigoushengBalance());
        agentSalary.setPingtuiBalance(agentSettle.getPingtuiBalance());
        agentSalary.setTechCharge(agentSettle.getTechCharge());
        agentSalary.setTechChargeRedpack(agentSettle.getTechChargeRedpack());
        agentSalary.setTechChargeOrder(agentSettle.getTechChargeOrder());
        agentSalary.setBankAccount(agentBankCard == null ? "" : agentBankCard.getBankAccount());
        agentSalary.setBankCardNumber(agentBankCard == null ? "" : agentBankCard.getBankCardNumber());
        agentSalary.setBankName(agentBankCard == null ? "" : agentBankCard.getBankName());
        agentSalary.setBranchName(agentBankCard == null ? "" : agentBankCard.getBranchName());
        agentSalary.setReferenceId(agentBankCard == null ? 0 : agentBankCard.getId());
        agentSalary.setStatus(10);
        agentSalary.setCreateTime(now);
        agentSalary.setModifyTime(null);
        agentSalary.setCreatedAt(now.getTime() / 1000L);
        agentSalary.setUpdatedAt(now.getTime() / 1000L);
        agentSalaryService.insert(agentSalary);
        return agentSalary;
    }

    private void insertAgentIncomeSummary(AgentSettle agentSettle, long beginTs, long endTs) {
        logger.info("agentSettle is {} ", agentSettle);
        Date dat = new Date(beginTs * 1000L);
        int now = (int) (System.currentTimeMillis() / 1000L);
        int yeartime = Integer.parseInt(DateUtils.getYear(dat));
        int monthtime = Integer.parseInt(DateUtils.getMonth(dat));
        AgentIncomeSummary agentIncomeSummary = agentIncomeSummaryService.getOneByAgentidYearMonth(agentSettle.getAgentId(), yeartime, monthtime);
        /**
         * 生成content字段
         */
        AgentSummaryContent agentSummaryContent = new AgentSummaryContent();
        agentSummaryContent.setPlaceCash(agentSettle.getPlaceCash().setScale(2, RoundingMode.HALF_UP));
        agentSummaryContent.setPlaceNum(agentSettle.getPlaceNum());
        agentSummaryContent.setOnlinerechargeCash(agentSettle.getOnlinerechargeCash().setScale(2, RoundingMode.HALF_UP));
        agentSummaryContent.setOnlinerechargeNum(agentSettle.getOnlinerechargeNum());
        agentSummaryContent.setOpencardCash(agentSettle.getOpenCardCash().setScale(2, RoundingMode.HALF_UP));
        agentSummaryContent.setOpencardNum(agentSettle.getOpenCardNum());
        agentSummaryContent.setUpgradePartnerCash(agentSettle.getUpgradePartnerCash().setScale(2, RoundingMode.HALF_UP));
        agentSummaryContent.setUpgradePartnerNum(agentSettle.getUpgradePartnerNum());
        agentSummaryContent.setMarketPerformance(agentSettle.getMarketPerformance().setScale(2, RoundingMode.HALF_UP));
        agentSummaryContent.setUpgradeMarketCash(agentSettle.getUpgradeMarketCash().setScale(2, RoundingMode.HALF_UP));
        agentSummaryContent.setRechargeMarketCash(agentSettle.getRechargeMarketCash().setScale(2, RoundingMode.HALF_UP));
        Integer expandUsers = agentExpandDailyService.getMonthCntByAgent(agentSettle.getAgentId(), beginTs, endTs);
        expandUsers = expandUsers == null ? 0 : expandUsers;
        agentSummaryContent.setExpandUsers(expandUsers);
        /**
         * 生成income字段
         */
        BigDecimal sum1 = agentSettle.getBalance();
        BigDecimal sum2 = agentSettle.getPlaceCash()
                .add(agentSettle.getOnlinerechargeCash())
                .add(agentSettle.getOpenCardCash())
                .add(agentSettle.getUpgradePartnerCash());
        if (sum1.compareTo(sum2) != 0) {
            logger.error("代理商奖励结算-对账异常: 求和1:{}, 求和2:{}, 奖励字段:{}", sum1, sum2, agentSettle);
            throw new RuntimeException();
        }
        if (null == agentIncomeSummary) {
            agentIncomeSummary = new AgentIncomeSummary();
            agentIncomeSummary.setUserId(agentSettle.getUserId());
            agentIncomeSummary.setAgentId(agentSettle.getAgentId());
            agentIncomeSummary.setYeartime(yeartime);
            agentIncomeSummary.setMonthtime(monthtime);
            agentIncomeSummary.setState(20);
            agentIncomeSummary.setCreatedAt(now);
            agentIncomeSummary.setUpdatedAt(now);
            agentIncomeSummary.setSettleTime(now);
            agentIncomeSummary.setContent(JSON.toJSONString(agentSummaryContent).replaceAll("0E-[0-9]+", "0"));
            agentIncomeSummary.setIncome(sum2);
            agentIncomeSummaryService.save(agentIncomeSummary);
        } else {
            agentIncomeSummary.setState(20);
            agentIncomeSummary.setSettleTime(now);
            agentIncomeSummary.setUpdatedAt(now);
            agentIncomeSummary.setContent(JSON.toJSONString(agentSummaryContent).replaceAll("0E-[0-9]+", "0"));
            agentIncomeSummary.setIncome(sum2);
            agentIncomeSummaryService.updateById(agentIncomeSummary);
        }
    }

    private int updateAgentRewardStatus(int agentId, long beginTs, long endTs) {
        return agentRewardService.updateRewardStatusByUidAndTs(agentId, beginTs, endTs);
    }

    private void updateAgentAccount(AgentSettle agentSettle, AgentAccount agentAccount) {
        /**
         * 更新合伙人账户金额
         */
        agentAccount.setBalance(agentAccount.getBalance()
                .add(agentSettle.getBalance())
                .subtract(agentSettle.getTechCharge())
                .subtract(agentSettle.getTax())
        );
        agentAccountService.updateById(agentAccount);
    }

    private void insertIntoAgentAccountLog(AgentSettle agentSettle, AgentAccount agentAccount, AgentSalary agentSalary, long beginTs) {
        Date dat = new Date(beginTs * 1000L);
        /**
         * 月结发钱
         */
        AgentSnapshot snapshot = new AgentSnapshot();
        snapshot.setAgentId(agentAccount.getAgentId());
        snapshot.setBalance(agentAccount.getBalance());
        BigDecimal changeNum = agentSettle.getBalance();
        BigDecimal changedAmount = agentAccount.getBalance().add(changeNum);
        AgentAccountLog log = createNewAgentAccountLog(agentSettle,
                Constants.PARTNER_ACCOUNT_LOG_TYPE_SETTLE,
                changeNum,
                changedAmount,
                DateUtils.format(dat, "yyyy-MM") + Constants.PARTNER_ACCOUNT_LOG_TYPE_SETTLE_REMARK,
                snapshot.toString(),
                agentSalary.getId());
        agentAccountLogService.save(log);
        /**
         * 平台技术服务费
         */
        changeNum = agentSettle.getTechCharge().negate();
        changedAmount = changedAmount.add(changeNum);
        if (changeNum.compareTo(ZERO) < 0) {
            log = createNewAgentAccountLog(agentSettle,
                    Constants.PARTNER_ACCOUNT_LOG_TYPE_TECH_CHARGE,
                    changeNum,
                    changedAmount,
                    DateUtils.format(dat, "yyyy-MM") + Constants.PARTNER_ACCOUNT_LOG_TYPE_TECH_CHARGE_REMARK,
                    "",
                    agentSalary.getId());
            agentAccountLogService.save(log);
        }
        /**
         * 个人所得税
         */
        changeNum = agentSettle.getTax().negate();
        if (changeNum.compareTo(ZERO) < 0) {
            changedAmount = changedAmount.add(changeNum);
            log = createNewAgentAccountLog(agentSettle,
                    Constants.PARTNER_ACCOUNT_LOG_TYPE_TAX,
                    changeNum,
                    changedAmount,
                    DateUtils.format(dat, "yyyy-MM") + Constants.PARTNER_ACCOUNT_LOG_TYPE_TAX_REMARK,
                    "",
                    agentSalary.getId());
            agentAccountLogService.save(log);
        }
    }

    private AgentAccountLog createNewAgentAccountLog(AgentSettle agentSettle, int type, BigDecimal changeNum, BigDecimal changedAmount, String payRemark, String snapshot, long agentSalaryId) {
        Date now = new Date();
        int yeartime = Integer.parseInt(DateUtils.getYear(now));
        int monthtime = Integer.parseInt(DateUtils.getMonth(now));
        int daytime = Integer.parseInt(DateUtils.getDay(now));
        AgentAccountLog log = new AgentAccountLog();
        log.setUserId(agentSettle.getUserId());
        log.setAgentId(agentSettle.getAgentId());
        log.setType(type);
        log.setChangeNum(changeNum);
        log.setChangedAmount(changedAmount);
        log.setPayRemark(payRemark);
        log.setPayType(false);
        log.setYeartime(yeartime);
        log.setMonthtime(monthtime);
        log.setDaytime(daytime);
        log.setSnapshot(JSON.toJSONString(snapshot).replaceAll("0E-[0-9]+", "0"));
        log.setChangeTime((int)(now.getTime() / 1000));
        log.setPayState(20);
        log.setPayPlatform("hupay");
        log.setPayInfo(payRemark);
        log.setReferenceId(agentSalaryId + "");
        return log;
    }
}
