package com.lanren.huhu.partner.model;

import com.lanren.huhu.partner.model.base.BaseModel;
import lombok.Data;

import java.util.ArrayList;

/**
 * @author chen
 * @title: PartnerTree
 * @projectName partner
 * @description: 存储合伙人的关系树结构, childrenList为其直属下级, parentList为父级关系
 * @package com.lanren.huhu.partner.model
 * @date 2019-06-28 11:17
 */
@Data
public class PartnerTree extends BaseModel {
    Integer userId;
    Integer level;
    ArrayList<ParentPartner> parentList;
    ArrayList<PartnerTree> childList = new ArrayList<PartnerTree>();

    public ArrayList<ParentPartner> cloneParent() {
        ArrayList<ParentPartner> copyList = new ArrayList<ParentPartner>();
        for (ParentPartner parentPartner : this.getParentList()) {
            ParentPartner one = new ParentPartner(parentPartner.getUserId(), parentPartner.getLevel());
            copyList.add(one);
        }
        return copyList;
    }
}
