package com.lanren.huhu.partner.model;

import com.lanren.huhu.partner.model.base.BaseModel;
import lombok.Data;

import java.util.ArrayList;

/**
 * @author chen
 * @title: AgentTree
 * @projectName partner
 * @description: 存储代理商的关系树结构, childrenList为其直属下级, parentList为父级关系
 * @package com.lanren.huhu.partner.model
 * @date 2019-07-02 20:15
 */
@Data
public class AgentTree extends BaseModel {
    Integer userId;
    Integer agentId;
    Integer level;
    ArrayList<ParentAgent> parentList;
    ArrayList<AgentTree> childList = new ArrayList<AgentTree>();

    public ArrayList<ParentAgent> cloneParent() {
        ArrayList<ParentAgent> copyList = new ArrayList<ParentAgent>();
        for (ParentAgent parentAgent : this.getParentList()) {
            ParentAgent one = new ParentAgent(parentAgent.getUserId(), parentAgent.getAgentId(), parentAgent.getLevel());
            copyList.add(one);
        }
        return copyList;
    }
}
