package com.lanren.huhu.partner.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import lombok.Data;

@Data
@TableName(value = "agent_bank_card")
public class AgentBankCard implements Serializable {
    /**
     * 主键id
     */
     @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 代理商id
     */
    @TableField(value = "agent_id")
    private Integer agentId;

    /**
     * 用户id
     */
    @TableField(value = "user_id")
    private Integer userId;

    /**
     * 姓名
     */
    @TableField(value = "real_name")
    private String realName;

    /**
     * 用户名称
     */
    @TableField(value = "user_phone")
    private String userPhone;

    /**
     * 币种编号 CNY人民币
     */
    @TableField(value = "currency_code")
    private String currencyCode;

    /**
     * 绑卡类型 个人or企业 10个人 20企业
     */
    @TableField(value = "bank_type")
    private Integer bankType;

    /**
     * 银行code
     */
    @TableField(value = "bank_code")
    private String bankCode;

    /**
     * 银行名称
     */
    @TableField(value = "bank_name")
    private String bankName;

    /**
     * 开户名称 个人姓名 企业 公司名称
     */
    @TableField(value = "bank_account")
    private String bankAccount;

    /**
     * 银行卡号
     */
    @TableField(value = "bank_card_number")
    private String bankCardNumber;

    /**
     * 支行名称
     */
    @TableField(value = "branch_name")
    private String branchName;

    /**
     * 银行所属省份
     */
    @TableField(value = "bank_province")
    private Integer bankProvince;

    /**
     * 银行所属城市
     */
    @TableField(value = "bank_city")
    private Integer bankCity;

    /**
     * 银行地址信息 省市
     */
    @TableField(value = "bank_address")
    private String bankAddress;

    /**
     * 银行卡状态 默认100正常 99 禁用
     */
    @TableField(value = "bank_state")
    private Integer bankState;

    /**
     * 证件号 身份证
     */
    @TableField(value = "idcard_no")
    private String idcardNo;

    /**
     * 身份证正面
     */
    @TableField(value = "idcard_pic_front")
    private String idcardPicFront;

    /**
     * 身份证反面
     */
    @TableField(value = "idcard_pic_back")
    private String idcardPicBack;

    /**
     * 营业执照或手持身份证照片
     */
    @TableField(value = "business_license")
    private String businessLicense;

    /**
     * 企业税号
     */
    @TableField(value = "tax_number")
    private String taxNumber;

    /**
     * 公司地址
     */
    @TableField(value = "company_address")
    private String companyAddress;

    /**
     * 公司联系电话
     */
    @TableField(value = "company_phone")
    private String companyPhone;

    /**
     * 税起征点 大于多少开始计算税
     */
    @TableField(value = "quota_node")
    private BigDecimal quotaNode;

    /**
     * 税率
     */
    @TableField(value = "tax_rate")
    private BigDecimal taxRate;

    /**
     * 开始使用时间
     */
    @TableField(value = "start_time")
    private Integer startTime;

    /**
     * 创建时间
     */
    @TableField(value = "create_time")
    private LocalDateTime createTime;

    /**
     * 创建时间
     */
    @TableField(value = "created_at")
    private Integer createdAt;

    /**
     * 修改时间
     */
    @TableField(value = "updated_at")
    private Integer updatedAt;

    /**
     * 删除信息
     */
    @TableField(value = "deleted_at")
    private Integer deletedAt;

    /**
     * 默认值 100 默认 99否
     */
    @TableField(value = "is_default")
    private Integer isDefault;

    private static final long serialVersionUID = 1L;

    public static final String COL_AGENT_ID = "agent_id";

    public static final String COL_USER_ID = "user_id";

    public static final String COL_REAL_NAME = "real_name";

    public static final String COL_USER_PHONE = "user_phone";

    public static final String COL_CURRENCY_CODE = "currency_code";

    public static final String COL_BANK_TYPE = "bank_type";

    public static final String COL_BANK_CODE = "bank_code";

    public static final String COL_BANK_NAME = "bank_name";

    public static final String COL_BANK_ACCOUNT = "bank_account";

    public static final String COL_BANK_CARD_NUMBER = "bank_card_number";

    public static final String COL_BRANCH_NAME = "branch_name";

    public static final String COL_BANK_PROVINCE = "bank_province";

    public static final String COL_BANK_CITY = "bank_city";

    public static final String COL_BANK_ADDRESS = "bank_address";

    public static final String COL_BANK_STATE = "bank_state";

    public static final String COL_IDCARD_NO = "idcard_no";

    public static final String COL_IDCARD_PIC_FRONT = "idcard_pic_front";

    public static final String COL_IDCARD_PIC_BACK = "idcard_pic_back";

    public static final String COL_BUSINESS_LICENSE = "business_license";

    public static final String COL_TAX_NUMBER = "tax_number";

    public static final String COL_COMPANY_ADDRESS = "company_address";

    public static final String COL_COMPANY_PHONE = "company_phone";

    public static final String COL_QUOTA_NODE = "quota_node";

    public static final String COL_TAX_RATE = "tax_rate";

    public static final String COL_START_TIME = "start_time";

    public static final String COL_CREATE_TIME = "create_time";

    public static final String COL_CREATED_AT = "created_at";

    public static final String COL_UPDATED_AT = "updated_at";

    public static final String COL_DELETED_AT = "deleted_at";

    public static final String COL_IS_DEFAULT = "is_default";
}