package com.lanren.huhu.partner.controller;

import com.lanren.huhu.partner.manager.AgentManager;
import com.lanren.huhu.partner.model.Agent;
import com.lanren.huhu.partner.model.AgentResponse;
import com.lanren.huhu.partner.model.ParentAgent;
import com.lanren.huhu.partner.result.Result;
import com.lanren.huhu.partner.schedule.AgentDailyExpandTask;
import com.lanren.huhu.partner.schedule.AgentSettleTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.time.LocalDateTime;
import java.util.ArrayList;

/**
 * @author chen
 */
@RestController
@RequestMapping("/v1/agent")
public class AgentController {
    private static Logger logger = LoggerFactory.getLogger(AgentController.class);

    @Autowired
    AgentManager agentManager;
    @Autowired
    AgentDailyExpandTask agentDailyExpandTask;
    @Autowired
    AgentSettleTask agentSettleTask;

    @RequestMapping(value = "/level", method = RequestMethod.POST)
    public Result<AgentResponse> getAgentLevel(@RequestBody @Valid Agent agent, @RequestHeader HttpHeaders headers) {
        if (logger.isInfoEnabled()) {
            logger.info("AgentController getLevel agentId:{},header:{},time:{}", agent.getAgentId(), headers.keySet().toArray(), LocalDateTime.now());
        }
        return agentManager.getAgentLevel(agent.getAgentId());
    }

    @RequestMapping(value = "/reward/push", method = RequestMethod.POST)
    public Result<String> pushReward(@RequestHeader HttpHeaders headers) {
        if (logger.isInfoEnabled()) {
            logger.info("AgentController pushReward, header:{},time:{}", headers.keySet().toArray(), LocalDateTime.now());
        }
        return agentManager.pushReward();
    }
    @RequestMapping(value = "/hierarchy/parent", method = RequestMethod.POST)
    public Result<ArrayList<ParentAgent>> getHierarchyParentList(@RequestBody @Valid Agent agent, @RequestHeader HttpHeaders headers) {
        if (logger.isInfoEnabled()) {
            logger.info("AgentController getHierarchyParentList, header:{},time:{}", headers.keySet().toArray(), LocalDateTime.now());
        }
        return agentManager.getHierarchyParentList(agent.getAgentId());
    }
    @RequestMapping(value = "/pingtui/parent", method = RequestMethod.POST)
    public Result<ArrayList<ParentAgent>> getPingtuiParentList(@RequestBody @Valid Agent agent, @RequestHeader HttpHeaders headers) {
        if (logger.isInfoEnabled()) {
            logger.info("AgentController getPingtuiParentList, header:{},time:{}", headers.keySet().toArray(), LocalDateTime.now());
        }
        return agentManager.getPingtuiParentList(agent.getAgentId());
    }
    @RequestMapping(value = "/expand/{dat}", method = RequestMethod.GET)
    public Result<String> updateOneDayExpand(@PathVariable("dat") String dat) {
        agentDailyExpandTask.runSummary(dat);
        logger.info("============>" + Thread.currentThread().getName());
        Result<String> result = new Result<String>();
        result.setData("异步,正在执行刷新......");
        return result;
    }

    @RequestMapping(value = "/finance/{agentId}", method = RequestMethod.GET)
    public Result<String> doFinanceSettle(@PathVariable("agentId") String agentId, @RequestHeader HttpHeaders headers) {
        if ("all".equals(agentId)) {
            /**
             * 结算全部代理商
             */
            agentSettleTask.runScheduledTask();
            logger.info("============>" + Thread.currentThread().getName());
            Result<String> result = new Result<String>();
            result.setData("异步,正在执行刷新......");
            return result;
        } else {
            /**
             * 测试使用 结算单个代理商
             */
            int aId = Integer.parseInt(agentId);
            if (logger.isInfoEnabled()) {
                logger.info("doFinanceSettle userId:{},header:{},time:{}", aId, headers.keySet().toArray(), LocalDateTime.now());
            }
            return agentManager.doFinanceSettle(aId);
        }
    }
}
